/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.cli.config.handlers.ScanTargetHandler;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanModelVisitable;
import com.ibm.appscan.common.model.utils.VisitingWriter;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.model.xml.ModelWriter;
import com.ibm.appscan.internal.cli.config.ConfigurationReader;
import com.ibm.appscan.internal.cli.config.ConfigurationWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConfigurationHandler
implements IModelXMLConstants {
    private static final String USER_DIR = System.getProperty("user.dir");
    private File m_config = null;
    private Map<String, Boolean> m_targetsToDiscover = null;
    private IConsole m_console = CommonCLICore.getIOConsole();

    public boolean create(String path) {
        boolean isCreated = false;
        IScan scan = ScanManager.getInstance().getActiveScan();
        ConfigurationWriter configurationWriter = new ConfigurationWriter();
        VisitingWriter writer = new VisitingWriter((IScanModelVisitable)scan, new File(USER_DIR), (ModelWriter)configurationWriter);
        try {
            writer.write((IProgress)new ProgressAdapter());
            isCreated = true;
        }
        catch (IOException e) {
            this.m_console.println(e.getMessage());
        }
        if (isCreated) {
            String configLocation = configurationWriter.getOutputLocation();
            this.m_console.println(Messages.bind(Messages.CONFIGURATION_FILE_CREATED, configLocation));
        }
        return isCreated;
    }

    public boolean create() {
        return this.create(USER_DIR);
    }

    public Map<String, Boolean> read(File configInput) {
        if (configInput == null) {
            IScan scan = ScanManager.getInstance().getActiveScan();
            if (scan.getScanTargets().isEmpty()) {
                ScanTargetHandler scanTargetHandler = new ScanTargetHandler();
                if (System.getProperty("unzipDir") != null) {
                    scanTargetHandler.addScanTarget(System.getProperty("unzipDir"), false);
                    System.clearProperty("unzipDir");
                } else {
                    scanTargetHandler.addScanTarget(USER_DIR, false);
                }
                this.m_targetsToDiscover = scanTargetHandler.getScanTargets();
            }
        } else {
            this.m_config = configInput;
            File configSchema = new File(CommonCore.getDirectoryLocator().getConfig() + File.separator + "appscan-config" + ".xsd");
            if (this.validateAgainstXSD(this.m_config, configSchema)) {
                this.load(this.m_config);
            } else {
                ProgressAdapter progress = new ProgressAdapter();
                progress.setStatus(new Message(4, Messages.INVALID_CONFIGURATION_FILE_XML));
                return null;
            }
        }
        return this.m_targetsToDiscover;
    }

    private void load(File file) {
        if (file == null || file.isDirectory()) {
            return;
        }
        String filename = file.getName();
        String name = filename.substring(0, filename.length() - 4);
        ConfigurationReader reader = new ConfigurationReader(file, name);
        try {
            reader.read();
            this.m_targetsToDiscover = reader.getScanTargetHandler().getScanTargets();
        }
        catch (FileNotFoundException e) {
            ProgressAdapter progress = new ProgressAdapter();
            progress.setStatus(new Message(4, Messages.bind(Messages.FILE_NOT_FOUND, filename)));
            progress.setStatus(new Message((Throwable)e));
        }
        catch (XMLStreamException e) {
            ProgressAdapter progress = new ProgressAdapter();
            progress.setStatus(new Message(4, Messages.CONFIGURATION_FILE_PARSING_ERROR));
            progress.setStatus(new Message((Throwable)e));
        }
    }

    private boolean validateAgainstXSD(File configFile, File configSchema) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new FileInputStream(configFile));
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory", ClassLoader.getSystemClassLoader());
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            Schema schema = schemaFactory.newSchema(new StreamSource(new FileInputStream(configSchema)));
            Validator validator = schema.newValidator();
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            validator.validate(new DOMSource(doc));
        }
        catch (FileNotFoundException e) {
            ProgressAdapter progress = new ProgressAdapter();
            progress.setStatus(new Message(4, Messages.bind(Messages.FILE_NOT_FOUND, configFile.getPath())));
            return false;
        }
        catch (ParserConfigurationException | SAXException e) {
            ProgressAdapter progress = new ProgressAdapter();
            progress.setStatus(new Message(4, Messages.CONFIGURATION_FILE_PARSING_ERROR));
            progress.setStatus(new Message((Throwable)e));
            return false;
        }
        catch (IOException e) {
            ProgressAdapter progress = new ProgressAdapter();
            progress.setStatus(new Message(4, Messages.bind(Messages.FILE_NOT_FOUND, configFile.getPath())));
            return false;
        }
        return true;
    }

    public boolean fileExists() {
        return this.m_config != null && this.m_config.exists();
    }

    public boolean isValidConfigFile(File config) {
        File configSchema = new File(CommonCore.getDirectoryLocator().getConfig() + File.separator + "appscan-config" + ".xsd");
        return this.validateAgainstXSD(config, configSchema);
    }
}

