/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common.components;

import com.ibm.appscan.cli.common.CLIConstants;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.Messages;
import com.ibm.appscan.cli.common.model.ICommand;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.ConnectionHelper;
import com.ibm.appscan.common.utils.SystemUtil;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public abstract class Command
implements ICommand,
CLIConstants {
    protected static ILogManager m_logManager = CommonCLICore.getLogManager();
    public static final int UNLIMITED_ARGS = -1;
    protected String[] m_args;
    private String m_namespace = null;
    private String m_name = null;
    private String m_alias = null;
    private String m_description = null;
    private int m_argNum = 0;
    private String m_argName = null;
    private int m_optionalArgNum = 0;
    private String m_optionalArgName = null;
    private Options m_options = null;
    private boolean m_enableLogLevels = false;
    private boolean m_debug = false;
    protected CommandLineParser m_parser = new BasicParser();
    protected HelpFormatter m_formatter = new HelpFormatter();

    public Command() {
        this(null);
    }

    public Command(String[] args) {
        this.m_args = args;
        this.configure();
        this.m_formatter.setSyntaxPrefix(Messages.getMessage("command.help.usage.prefix", new Object[0]));
    }

    public abstract void configure();

    public abstract Command createCommand(String[] var1);

    @Override
    public abstract void execute();

    public boolean shouldRegister() {
        return true;
    }

    public CommandLine getCommandLine() {
        CommandLine cmd = null;
        try {
            cmd = this.m_parser.parse(this.getOptions(), this.m_args);
            if (this.m_enableLogLevels) {
                CommonCLICore.getIOConsole().setLogLevel(this.getLogLevel(cmd));
            }
            if (this.m_debug && cmd.hasOption("X")) {
                System.setProperty("DEBUG", "");
            }
            if (cmd.hasOption("acceptssl") || SystemUtil.shouldAcceptSSL()) {
                System.setProperty("acceptssl", "");
                this.acceptSSL();
            }
            if (cmd != null) {
                String[] unknownArgs = cmd.getArgs();
                int min = Math.min(this.m_argNum, this.m_optionalArgNum);
                int max = Math.max(this.m_argNum, this.m_optionalArgNum);
                if (min != -1 && unknownArgs.length > max) {
                    cmd = null;
                    throw new ParseException(Messages.getMessage("argument.err", unknownArgs[max]));
                }
            }
        }
        catch (ParseException e) {
            CommonCLICore.getLogManager().log(new Message((Throwable)e));
            CommonCLICore.getIOConsole().println(new Message((Throwable)e));
        }
        return cmd;
    }

    public void acceptSSL() {
        try {
            ConnectionHelper.bypassSSL();
        }
        catch (GeneralSecurityException e) {
            CommonCLICore.getLogManager().log(new Message((Throwable)e));
            CommonCLICore.getIOConsole().println(new Message((Throwable)e));
        }
    }

    public int getLogLevel(CommandLine cmd) {
        if (this.m_enableLogLevels && cmd.hasOption("v")) {
            if (this.m_debug && cmd.hasOption("X")) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    protected abstract Options buildOptions();

    @Override
    public boolean canExecute() {
        return this.m_args != null;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getName() {
        return this.m_name;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public String getDescription() {
        return this.m_description;
    }

    protected Options getVisibleOptions(Options options) {
        return options;
    }

    @Override
    public void printHelp() {
        this.m_formatter.printHelp(CommonCLICore.getIOConsole().getPrintWriter(), this.m_formatter.getWidth(), this.formatHelpSyntax(), this.m_description, this.getVisibleOptions(this.m_options), this.m_formatter.getLeftPadding(), this.m_formatter.getDescPadding(), null, true);
        CommonCLICore.getIOConsole().getPrintWriter().flush();
    }

    private String formatHelpSyntax() {
        String helpSyntax = this.m_name;
        if (this.m_alias != null) {
            helpSyntax = helpSyntax + "/" + this.m_alias;
        }
        if (this.m_argNum > 0 || this.m_argNum == -1) {
            helpSyntax = helpSyntax + " <";
            helpSyntax = this.m_argName != null ? helpSyntax + this.m_argName : helpSyntax + "arg";
            helpSyntax = helpSyntax + ">";
            if (this.m_argNum == -1) {
                helpSyntax = helpSyntax + " ...";
            }
        }
        if (this.m_optionalArgNum > 0 || this.m_optionalArgNum == -1) {
            helpSyntax = helpSyntax + " [";
            helpSyntax = this.m_optionalArgName != null ? helpSyntax + this.m_optionalArgName : helpSyntax + "arg";
            helpSyntax = helpSyntax + "]";
            if (this.m_optionalArgNum == -1) {
                helpSyntax = helpSyntax + " ...";
            }
        }
        return helpSyntax;
    }

    public Options getOptions() {
        return this.m_options;
    }

    public void setNamespace(String namespace) {
        this.m_namespace = namespace;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void hasArg(boolean hasArg) {
        this.m_argNum = hasArg ? 1 : 0;
    }

    public void hasArgs(int num) {
        this.m_argNum = num;
    }

    public void hasArgs(boolean hasArgs) {
        this.m_argNum = hasArgs ? -1 : 0;
    }

    public boolean hasArg() {
        return this.m_argNum == 1;
    }

    public int getArgs() {
        return this.m_argNum;
    }

    public boolean hasArgs() {
        return this.m_argNum > 1 || this.m_argNum == -1;
    }

    public void setArgName(String name) {
        this.m_argName = name;
    }

    public void hasOptionalArg(boolean hasArg) {
        this.m_optionalArgNum = hasArg ? 1 : 0;
    }

    public void hasOptionalArgs(int num) {
        this.m_optionalArgNum = num;
    }

    public void hasOptionalArgs(boolean hasArgs) {
        this.m_optionalArgNum = hasArgs ? -1 : 0;
    }

    public boolean hasOptionalArg() {
        return this.m_optionalArgNum > 0 || this.m_optionalArgNum == -1;
    }

    public int getOptionalArgs() {
        return this.m_optionalArgNum;
    }

    public boolean hasOptionalArgs() {
        return this.m_optionalArgNum > 1 || this.m_optionalArgNum == -1;
    }

    public void setOptionalArgName(String name) {
        this.m_optionalArgName = name;
    }

    public void setOptions(Options options, boolean debug) {
        if (options == null) {
            options = new Options();
        }
        if (this.m_options != null) {
            Iterator iter = options.getOptions().iterator();
            while (iter.hasNext()) {
                this.m_options.addOption((Option)iter.next());
            }
        } else {
            this.m_options = options;
        }
        if (debug) {
            this.m_debug = true;
            this.m_options.addOption("X", "debug", false, Messages.getMessage("option.debug.description", new Object[0]));
        }
        this.m_options.addOption("acceptssl", false, "");
    }

    public void enableLogLevelOptions() {
        this.m_enableLogLevels = true;
        if (this.m_options == null) {
            this.m_options = new Options();
        }
        this.m_options.addOption("v", "verbose", false, Messages.getMessage("option.verbose.description", new Object[0]));
    }

    public CommandLineParser useGNUParser() {
        this.m_parser = new GnuParser();
        return this.m_parser;
    }

    public CommandLineParser usePosixParser() {
        this.m_parser = new PosixParser();
        return this.m_parser;
    }

    public CommandLineParser useBasicParser() {
        this.m_parser = new BasicParser();
        return this.m_parser;
    }

    public CommandLine parseArguments(Options options, String[] args) {
        CommandLine cmdLn = null;
        try {
            cmdLn = this.m_parser.parse(this.getOptions(), args);
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
        }
        return cmdLn;
    }

    protected boolean getDebug() {
        return this.m_debug;
    }

    protected boolean getEnableLogLevels() {
        return this.m_enableLogLevels;
    }
}

