/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common.components;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.model.IPrompt;
import com.ibm.appscan.common.model.IConsole;

public class Prompt
implements IPrompt {
    private IConsole m_console = CommonCLICore.getIOConsole();
    private String PROMPT_SUFFIX;
    private static String DEFAULT_PROMPT_SUFFIX = "> ";
    private String PROMPT_CONTEXT;
    private static String DEFAULT_PROMPT_CONTEXT = "";

    public Prompt() {
        this(DEFAULT_PROMPT_CONTEXT);
    }

    public Prompt(String context) {
        this.setPromptContext(context);
    }

    @Override
    public void prompt() {
        this.m_console.print(this.getPromptMessage());
    }

    public String getPromptMessage() {
        String s = this.getPromptContext() + this.getPromptSuffix();
        return s;
    }

    public void setPromptSuffix(String newSuffix) {
        this.PROMPT_SUFFIX = newSuffix;
    }

    public void setPromptContext(String newContext) {
        this.PROMPT_CONTEXT = newContext;
    }

    public void setDefaultPromptContext(String newContext) {
        DEFAULT_PROMPT_CONTEXT = newContext;
        this.PROMPT_CONTEXT = newContext;
    }

    public void setDefaultPromptSuffix(String newSuffix) {
        DEFAULT_PROMPT_SUFFIX = newSuffix;
        this.PROMPT_SUFFIX = newSuffix;
    }

    public String getPromptContext() {
        return this.PROMPT_CONTEXT == null || this.PROMPT_CONTEXT.isEmpty() ? DEFAULT_PROMPT_CONTEXT : this.PROMPT_CONTEXT;
    }

    public String getPromptSuffix() {
        return this.PROMPT_SUFFIX == null || this.PROMPT_SUFFIX.isEmpty() ? DEFAULT_PROMPT_SUFFIX : this.PROMPT_SUFFIX;
    }

    public String getDefaultPromptContext() {
        return DEFAULT_PROMPT_CONTEXT.isEmpty() ? null : DEFAULT_PROMPT_CONTEXT;
    }

    public String getDefaultPromptSuffix() {
        return DEFAULT_PROMPT_SUFFIX.isEmpty() ? null : DEFAULT_PROMPT_SUFFIX;
    }

    @Override
    public void reset() {
        this.PROMPT_CONTEXT = DEFAULT_PROMPT_CONTEXT;
        this.PROMPT_SUFFIX = DEFAULT_PROMPT_SUFFIX;
    }

    @Override
    public void update(String context, String suffix) {
        if (context != null) {
            this.setPromptContext(context);
        }
        if (suffix != null) {
            this.setPromptSuffix(suffix);
        }
    }

    @Override
    public void updateDefaults(String context, String suffix) {
        if (context != null) {
            this.setDefaultPromptContext(context);
        }
        if (suffix != null) {
            this.setDefaultPromptSuffix(suffix);
        }
    }
}

