/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util.dependencyAnalysis;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.jstaint.util.dependencyAnalysis.DAGraph;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PackageDependencyAnalyzer {
    private final Map<ModuleEntry, Module> moduleEntryToModule = HashMapFactory.make();
    private final Map<Module, Set<ModuleEntry>> moduleToModuleEntry = HashMapFactory.make();
    private final Set<ModuleEntry> allModuleEntries = HashSetFactory.make();
    private final DAGraph graph;

    public PackageDependencyAnalyzer(Set<Module> allModules) throws InvalidClassFileException, Decoder.InvalidBytecodeException {
        for (Module m : allModules) {
            Iterator meIter = m.getEntries();
            while (meIter.hasNext()) {
                ModuleEntry me = (ModuleEntry)meIter.next();
                if (!me.isClassFile()) continue;
                this.moduleEntryToModule.put(me, m);
                Set moduleEntriesForModule = MapUtil.findOrCreateSet(this.moduleToModuleEntry, (Object)m);
                moduleEntriesForModule.add(me);
                this.allModuleEntries.add(me);
            }
        }
        this.graph = new DAGraph(this.allModuleEntries);
    }

    public Set<Module> getDependentModules(Set<Module> rootModules) {
        HashSet rootModuleEntries = HashSetFactory.make();
        for (Module m : rootModules) {
            Set<ModuleEntry> entries = this.moduleToModuleEntry.get(m);
            if (entries == null) continue;
            rootModuleEntries.addAll(entries);
        }
        Set<TypeReference> rootTypes = this.graph.getTypesForModuleEntries(rootModuleEntries);
        Set<TypeReference> reachableTypes = this.graph.getReachableTypes(rootTypes);
        Set<ModuleEntry> reachableModuleEntries = this.graph.getModuleEntriesForTypes(reachableTypes);
        HashSet reachableModules = HashSetFactory.make();
        for (ModuleEntry me : reachableModuleEntries) {
            Module m = this.moduleEntryToModule.get(me);
            if (m == null) continue;
            reachableModules.add(m);
        }
        return reachableModules;
    }
}

