/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.auth.handlers;

import com.ibm.appscan.cli.cloud.auth.Messages;
import com.ibm.appscan.cli.cloud.auth.handlers.LoginType;
import com.ibm.appscan.cli.cloud.auth.providers.AuthenticationProvider;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.common.utils.ConnectionHelper;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.utils.WebServiceUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class LoginHandler
implements SaaSConstants {
    private HttpClient m_httpClient;
    private IConsole m_console = CommonCLICore.getIOConsole();
    private IProgress m_progress = new ProgressAdapter();
    private AuthenticationProvider m_authProvider = AuthenticationProvider.getInstance();

    protected String getServer(String key) {
        return WebServiceUtil.getServer((String)key);
    }

    public boolean login(String username, char[] password, boolean acceptSSL, boolean persist, LoginType type) {
        return this.login(username, password, acceptSSL, persist, type, null);
    }

    public boolean login(String username, char[] password, boolean acceptSSL, boolean persist, LoginType type, String clientType) {
        return this.login(username, password, acceptSSL, persist, type, clientType, this.getServer(username));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String username, char[] password, boolean acceptSSL, boolean persist, LoginType type, String clientType, String server) {
        if (server == null) {
            server = this.getServer(username);
        }
        String accessToken = null;
        String apiEnvironment = "SCX";
        try {
            this.m_httpClient = new HttpClient();
            accessToken = this.externalLogin(server, username, password, type, clientType, acceptSSL);
            boolean bl = this.saveToken(accessToken, server, apiEnvironment, persist, username, password, acceptSSL, type);
            return bl;
        }
        catch (SSLHandshakeException e) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("err.ssl", server)));
            CommonCLICore.getLogManager().log(new Message(4, Messages.getMessage("err.ssl", server)));
            boolean bl = false;
            return bl;
        }
        catch (IOException | GeneralSecurityException e) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("login.error", server)));
            CommonCLICore.getLogManager().log(new Message((Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            Arrays.fill(password, '0');
        }
    }

    private boolean saveToken(String accessToken, String server, String apiEnvironment, boolean persist, String username, char[] password, boolean acceptSSL, LoginType type) {
        HashMap<String, char[]> connectionProperties = new HashMap<String, char[]>();
        connectionProperties.put("connection.server", server.toCharArray());
        connectionProperties.put("connection.token", accessToken != null ? accessToken.toCharArray() : null);
        connectionProperties.put("connection.environment", apiEnvironment.toCharArray());
        if (persist) {
            connectionProperties.put("connection.persist", "true".toCharArray());
            connectionProperties.put("connection.username", username.toCharArray());
            connectionProperties.put("connection.password", password);
        }
        if (acceptSSL) {
            connectionProperties.put("connection.bypassSSL", "true".toCharArray());
        }
        if (type == LoginType.ASoC_Federated) {
            connectionProperties.put("connection.federated", "true".toCharArray());
        }
        if (accessToken == null || apiEnvironment == null || !this.m_authProvider.saveConnection(connectionProperties)) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("login.error", server)));
            return false;
        }
        this.m_console.println(Messages.getMessage("login.success", new Object[0]));
        return true;
    }

    public boolean saveToken(String accessToken, String username, char[] password) {
        if (username == null) {
            return this.saveToken(accessToken, WebServiceUtil.getSCXServer(), "SCX", false, null, null, false, LoginType.ASoC);
        }
        return this.saveToken(accessToken, WebServiceUtil.getSCXServer(), "SCX", true, username, password, false, LoginType.ASoC_Federated);
    }

    private String externalLogin(String server, String username, char[] password, LoginType type, String clientType, boolean acceptssl) throws IOException, GeneralSecurityException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("charset", "utf-8");
        if (acceptssl) {
            ConnectionHelper.bypassSSL();
        }
        if (clientType != null) {
            clientType = clientType.replaceAll("[^a-zA-Z0-9\\-\\._]", "");
            headers.put("ClientType", clientType);
        } else {
            headers.put("ClientType", String.valueOf(SystemUtil.getClientType()));
        }
        JSONObject params = new JSONObject();
        String url = null;
        HttpResponse response = null;
        try {
            if (clientType != null) {
                clientType = clientType.replaceAll("[^a-zA-Z0-9\\-\\._]", "");
                params.put("ClientType", (Object)clientType);
            }
            params.put("KeyId", (Object)username);
            params.put("KeySecret", (Object)new String(password));
            url = server + "/api/v4/Account/ApiKeyLogin";
            response = this.m_httpClient.post(url, headers, params.toString().toCharArray());
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        return this.extractToken(response, "Token");
    }

    @SuppressSecurityTrace
    private String extractToken(HttpResponse response, String tokenType) throws IOException {
        String token = null;
        try {
            JSONArtifact json = response.getResponseBodyAsJSON();
            if (response != null && response.getResponseCode() == 200) {
                JSONObject object = (JSONObject)json;
                token = object.getString(tokenType);
            }
        }
        catch (JSONException e) {
            CommonCLICore.getLogManager().log(new Message((Throwable)e));
        }
        return token;
    }
}

