/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.filter.conditions;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.filter.FilterEnums;
import com.ibm.appscan.filter.conditions.RegexTraceNodeCondition;
import java.util.ArrayList;

public abstract class Condition {
    private String m_value;
    private ArrayList<Condition> m_children = new ArrayList();
    private Condition m_parent;

    public Condition(String value, Condition parent) {
        this.m_value = value;
        this.m_parent = parent;
    }

    public void addChildCondition(Condition c) {
        this.m_children.add(c);
        c.setParent(this);
    }

    public Condition addRegexCondition(String value) {
        RegexTraceNodeCondition c = new RegexTraceNodeCondition(value, this);
        this.addChildCondition(c);
        return c;
    }

    public void setParent(Condition c) {
        this.m_parent = c;
    }

    public Condition getParent() {
        return this.m_parent;
    }

    public ArrayList<Condition> getChildren() {
        return this.m_children;
    }

    public boolean isMatch(Finding f) {
        if (!this.isMatch_(f)) {
            return false;
        }
        for (Condition child : this.m_children) {
            if (child.isMatch(f)) continue;
            return false;
        }
        return true;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    protected abstract ArrayList<String> getNodesToCheck(Finding var1);

    protected abstract boolean isMatch_(Finding var1);

    public abstract FilterEnums.CONDITION_TYPE getConditionType();

    public abstract FilterEnums.CONDITION_MATCH_TYPE getMatchType();
}

