/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.filter.conditions;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.filter.FilterEnums;
import com.ibm.appscan.filter.conditions.Condition;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class RegexTraceNodeCondition
extends Condition {
    private Pattern m_pattern = Pattern.compile(this.getValue());

    public RegexTraceNodeCondition(String value, Condition parent) {
        super(value, parent);
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        this.m_pattern = Pattern.compile(this.getValue());
    }

    @Override
    public boolean isMatch_(Finding f) {
        ArrayList<String> nodes = this.getNodesToCheck(f);
        for (String node : nodes) {
            if (!this.m_pattern.matcher(node).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FilterEnums.CONDITION_TYPE getConditionType() {
        return FilterEnums.CONDITION_TYPE.REGEX;
    }

    @Override
    public FilterEnums.CONDITION_MATCH_TYPE getMatchType() {
        return FilterEnums.CONDITION_MATCH_TYPE.ALL;
    }

    @Override
    protected ArrayList<String> getNodesToCheck(Finding f) {
        return this.getParent().getNodesToCheck(f);
    }
}

