/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph;

import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.js.callgraph.fieldbased.JSMethodInstructionVisitor;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.FlowGraph;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.CreationSiteVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.FuncVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.LexicalVarVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.PropVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.RetVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.UnknownVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VarVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.Vertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VertexFactory;
import com.ibm.wala.cast.js.ipa.callgraph.JSCallGraphUtil;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyRead;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyWrite;
import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.cast.js.ssa.SetPrototype;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.js.util.Util;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

public class FlowGraphBuilder {
    private final IClassHierarchy cha;
    private final AnalysisCache cache;
    private final boolean supportFullPointerAnalysis;
    private static String[] primitiveFunctions = new String[]{"Object", "Function", "Array", "StringObject", "NumberObject", "BooleanObject", "RegExp"};

    public FlowGraphBuilder(IClassHierarchy cha, AnalysisCache cache, boolean supportPointerAnalysis) {
        this.cha = cha;
        this.cache = cache;
        this.supportFullPointerAnalysis = supportPointerAnalysis;
    }

    public FlowGraph buildFlowGraph() {
        FlowGraph flowgraph = new FlowGraph();
        this.addPrimitives(flowgraph);
        this.visitProgram(flowgraph);
        return flowgraph;
    }

    public void visitProgram(FlowGraph flowgraph) {
        for (IClass klass : this.cha) {
            for (IMethod method : klass.getDeclaredMethods()) {
                if (!method.getDescriptor().equals((Object)AstMethodReference.fnDesc)) continue;
                this.visitFunction(flowgraph, method);
            }
        }
    }

    public void visitFunction(FlowGraph flowgraph, IMethod method) {
        if (method.toString().contains("ctor") && method.toString().contains("dollar_init")) {
            System.err.println("found it");
        }
        IR ir = this.cache.getIR(method);
        FlowGraphSSAVisitor visitor = new FlowGraphSSAVisitor(ir, flowgraph);
        SSAInstruction[] normalInstructions = ir.getInstructions();
        for (int i = 0; i < normalInstructions.length; ++i) {
            if (normalInstructions[i] == null) continue;
            visitor.instructionIndex = i;
            normalInstructions[i].visit((SSAInstruction.IVisitor)visitor);
        }
        visitor.instructionIndex = -1;
        Iterator iter = ir.iteratePhis();
        while (iter.hasNext()) {
            ((SSAInstruction)iter.next()).visit((SSAInstruction.IVisitor)visitor);
        }
        iter = ir.iterateCatchInstructions();
        while (iter.hasNext()) {
            ((SSAInstruction)iter.next()).visit((SSAInstruction.IVisitor)visitor);
        }
    }

    private void addPrimitives(FlowGraph flowgraph) {
        VertexFactory factory = flowgraph.getVertexFactory();
        for (String pf : primitiveFunctions) {
            TypeReference typeref = TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (String)("L" + pf));
            IClass klass = this.cha.lookupClass(typeref);
            String prop = pf.endsWith("Object") ? pf.substring(0, pf.length() - 6) : pf;
            flowgraph.addEdge(factory.makeFuncVertex(klass), factory.makePropVertex(prop));
        }
    }

    private class FlowGraphSSAVisitor
    extends JSMethodInstructionVisitor {
        public int instructionIndex;
        private final FlowGraph flowgraph;
        private final VertexFactory factory;
        private final AstMethod.LexicalInformation lexicalInfo;
        private final IntSet exposedVars;
        private final IR ir;
        private final FuncVertex func;

        public FlowGraphSSAVisitor(IR ir, FlowGraph flowgraph) {
            super(ir.getMethod(), ir.getSymbolTable(), FlowGraphBuilder.this.cache.getDefUse(ir));
            this.instructionIndex = -1;
            this.ir = ir;
            this.flowgraph = flowgraph;
            this.factory = flowgraph.getVertexFactory();
            this.func = this.factory.makeFuncVertex(ir.getMethod().getDeclaringClass());
            if (this.method instanceof AstMethod) {
                this.lexicalInfo = ((AstMethod)this.method).lexicalInfo();
                this.exposedVars = this.lexicalInfo.getAllExposedUses();
            } else {
                this.lexicalInfo = null;
                this.exposedVars = EmptyIntSet.instance;
            }
        }

        private void handleLexicalDef(int def) {
            assert (def != -1);
            if (this.instructionIndex != -1 && this.exposedVars.contains(def)) {
                VarVertex v = this.factory.makeVarVertex(this.func, def);
                for (String localName : this.ir.getLocalNames(this.instructionIndex, def)) {
                    this.flowgraph.addEdge(v, this.factory.makeLexicalAccessVertex(this.lexicalInfo.getScopingName(), localName));
                }
            }
        }

        public void visitPhi(SSAPhiInstruction phi) {
            int n = phi.getNumberOfUses();
            VarVertex w = this.factory.makeVarVertex(this.func, phi.getDef());
            for (int i = 0; i < n; ++i) {
                VarVertex v = this.factory.makeVarVertex(this.func, phi.getUse(i));
                this.flowgraph.addEdge(v, w);
            }
        }

        @Override
        public void visitPrototypeLookup(PrototypeLookup proto) {
            this.flowgraph.addEdge(this.factory.makeVarVertex(this.func, proto.getUse(0)), this.factory.makeVarVertex(this.func, proto.getDef()));
            this.handleLexicalDef(proto.getDef());
        }

        private void visitPut(int val, String propName) {
            VarVertex v = this.factory.makeVarVertex(this.func, val);
            PropVertex w = this.factory.makePropVertex(propName);
            this.flowgraph.addEdge(v, w);
        }

        public void visitPut(SSAPutInstruction put) {
            this.visitPut(put.getVal(), put.getDeclaredField().getName().toString());
        }

        @Override
        public void visitSetPrototype(SetPrototype instruction) {
            this.visitPut(instruction.getUse(1), "prototype");
        }

        public void visitAstGlobalWrite(AstGlobalWrite instruction) {
            String propName = instruction.getDeclaredField().getName().toString();
            assert (propName.startsWith("global "));
            propName = propName.substring("global ".length());
            this.visitPut(instruction.getVal(), propName);
        }

        @Override
        public void visitJavaScriptPropertyWrite(JavaScriptPropertyWrite pw) {
            int p = pw.getMemberRef();
            if (this.symtab.isConstant(p)) {
                String pn = JSCallGraphUtil.simulateToStringForPropertyNames(this.symtab.getConstantValue(p));
                VarVertex v = this.factory.makeVarVertex(this.func, pw.getValue());
                PropVertex w = this.factory.makePropVertex(pn);
                this.flowgraph.addEdge(v, w);
            }
        }

        public void visitAstLexicalWrite(AstLexicalWrite lw) {
            for (AstLexicalAccess.Access acc : lw.getAccesses()) {
                VarVertex v = this.factory.makeVarVertex(this.func, acc.valueNumber);
                LexicalVarVertex w = this.factory.makeLexicalAccessVertex(acc.variableDefiner, acc.variableName);
                this.flowgraph.addEdge(v, w);
            }
        }

        public void visitGet(SSAGetInstruction get) {
            String propName = get.getDeclaredField().getName().toString();
            if (propName.startsWith("global ")) {
                propName = propName.substring("global ".length());
            }
            PropVertex v = this.factory.makePropVertex(propName);
            VarVertex w = this.factory.makeVarVertex(this.func, get.getDef());
            this.flowgraph.addEdge(v, w);
            this.handleLexicalDef(get.getDef());
        }

        public void visitAstGlobalRead(AstGlobalRead instruction) {
            if (FlowGraphBuilder.this.supportFullPointerAnalysis && instruction.getGlobalName().endsWith("__WALA__int3rnal__global")) {
                VarVertex lval = this.factory.makeVarVertex(this.func, instruction.getDef());
                this.flowgraph.addEdge(this.factory.global(), lval);
            } else {
                this.visitGet((SSAGetInstruction)instruction);
            }
        }

        @Override
        public void visitJavaScriptPropertyRead(JavaScriptPropertyRead pr) {
            IntSet argVns;
            VarVertex w;
            Vertex v;
            int p = pr.getMemberRef();
            if (this.symtab.isConstant(p)) {
                String pn = JSCallGraphUtil.simulateToStringForPropertyNames(this.symtab.getConstantValue(p));
                v = this.factory.makePropVertex(pn);
                w = this.factory.makeVarVertex(this.func, pr.getDef());
                this.flowgraph.addEdge(v, w);
            }
            if ((argVns = Util.getArgumentsArrayVns(this.ir, this.du)).contains(pr.getObjectRef())) {
                v = this.factory.makeArgVertex(this.func);
                w = this.factory.makeVarVertex(this.func, pr.getDef());
                this.flowgraph.addEdge(v, w);
            }
            this.handleLexicalDef(pr.getDef());
        }

        public void visitAstLexicalRead(AstLexicalRead lr) {
            for (AstLexicalAccess.Access acc : lr.getAccesses()) {
                LexicalVarVertex v = this.factory.makeLexicalAccessVertex(acc.variableDefiner, acc.variableName);
                VarVertex w = this.factory.makeVarVertex(this.func, acc.valueNumber);
                this.flowgraph.addEdge(v, w);
                this.handleLexicalDef(acc.valueNumber);
            }
        }

        public void visitReturn(SSAReturnInstruction ret) {
            VarVertex v = this.factory.makeVarVertex(this.func, ret.getResult());
            RetVertex w = this.factory.makeRetVertex(this.func);
            this.flowgraph.addEdge(v, w);
        }

        public void visitThrow(SSAThrowInstruction thr) {
            VarVertex v = this.factory.makeVarVertex(this.func, thr.getException());
            UnknownVertex w = this.factory.makeUnknownVertex();
            this.flowgraph.addEdge(v, w);
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction katch) {
            UnknownVertex v = this.factory.makeUnknownVertex();
            VarVertex w = this.factory.makeVarVertex(this.func, katch.getDef());
            this.flowgraph.addEdge(v, w);
        }

        @Override
        public void visitJavaScriptInvoke(JavaScriptInvoke invk) {
            this.flowgraph.addEdge(this.factory.makeUnknownVertex(), this.factory.makeVarVertex(this.func, invk.getException()));
            if (invk.getDeclaredTarget().equals((Object)JavaScriptMethods.ctorReference)) {
                this.flowgraph.addEdge(this.factory.makeVarVertex(this.func, invk.getFunction()), this.factory.makeCallVertex(this.func, invk));
                if (this.isFunctionConstructorInvoke(invk)) {
                    String fn_name = this.symtab.getStringValue(invk.getUse(1));
                    if (fn_name == null || fn_name.trim().length() == 0) {
                        return;
                    }
                    IClass klass = FlowGraphBuilder.this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (String)fn_name));
                    if (klass == null) {
                        System.err.println("cannot find " + fn_name + " at " + ((AstMethod)this.ir.getMethod()).getSourcePosition(this.ir.getCallInstructionIndices(invk.getCallSite()).intIterator().next()));
                        return;
                    }
                    IMethod fn = klass.getMethod(AstMethodReference.fnSelector);
                    FuncVertex fnVertex = this.factory.makeFuncVertex(klass);
                    this.flowgraph.addEdge(fnVertex, this.factory.makeVarVertex(fnVertex, 1));
                    for (int i = 1; i < fn.getNumberOfParameters(); ++i) {
                        this.flowgraph.addEdge(this.factory.makeParamVertex(fnVertex, i), this.factory.makeVarVertex(fnVertex, i + 1));
                    }
                    this.flowgraph.addEdge(fnVertex, this.factory.makeVarVertex(this.func, invk.getDef()));
                } else if (FlowGraphBuilder.this.supportFullPointerAnalysis) {
                    CreationSiteVertex cs = this.factory.makeCreationSiteVertex(this.method, invk.iindex, JavaScriptTypes.Object);
                    this.flowgraph.addEdge(cs, this.factory.makeVarVertex(this.func, invk.getDef()));
                    if (invk.getNumberOfParameters() > 1) {
                        this.flowgraph.addEdge(cs, this.factory.makeVarVertex(this.func, invk.getUse(0)));
                    }
                }
            } else if (invk.getDeclaredTarget().equals((Object)JavaScriptMethods.dispatchReference)) {
                if (this.symtab.isConstant(invk.getFunction())) {
                    String pn = JSCallGraphUtil.simulateToStringForPropertyNames(this.symtab.getConstantValue(invk.getFunction()));
                    this.flowgraph.addEdge(this.factory.makePropVertex(pn), this.factory.makeCallVertex(this.func, invk));
                }
            } else {
                this.flowgraph.addEdge(this.factory.makeVarVertex(this.func, invk.getFunction()), this.factory.makeCallVertex(this.func, invk));
            }
            this.handleLexicalDef(invk.getDef());
        }

        public void visitNew(SSANewInstruction invk) {
            if (FlowGraphBuilder.this.supportFullPointerAnalysis) {
                CreationSiteVertex cs = this.factory.makeCreationSiteVertex(this.method, invk.iindex, invk.getConcreteType());
                this.flowgraph.addEdge(cs, this.factory.makeVarVertex(this.func, invk.getDef()));
            }
        }
    }
}

