/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.cg.util;

import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class LRUMap<T, K>
implements Map<T, K> {
    private static final double REMOVE_FACTOR = 0.2;
    private final Map<T, K> map = HashMapFactory.make();
    private final LinkedList<T> lru = new LinkedList();
    private final int maxCapacity;
    private final int removeCount;

    public LRUMap(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.removeCount = (int)((double)maxCapacity * 0.2);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.lru.clear();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.map.containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.map.containsValue(arg0);
    }

    @Override
    public Set<Map.Entry<T, K>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public K get(Object arg0) {
        return this.map.get(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<T> keySet() {
        return this.map.keySet();
    }

    @Override
    public K put(T arg0, K arg1) {
        this.lru.remove(arg0);
        this.lru.addFirst(arg0);
        K result = this.map.put(arg0, arg1);
        if (this.lru.size() > this.maxCapacity) {
            for (int i = 0; i < this.removeCount; ++i) {
                T removedKey = this.lru.removeLast();
                this.map.remove(removedKey);
            }
            assert (this.lru.size() <= this.maxCapacity);
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends T, ? extends K> arg0) {
        for (Map.Entry<T, K> entry : arg0.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public K remove(Object arg0) {
        this.lru.remove(arg0);
        return this.map.remove(arg0);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<K> values() {
        return this.map.values();
    }
}

