/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.incremental.ISupportGraph;
import com.ibm.wala.andromeda.lang.OverwriteInfo;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import java.util.Set;

public class RawAnalysisResult {
    private final Set<Variable> propagationSeeds;
    private final ISupportGraph supportGraph;
    private final AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propagationGraph;
    private final boolean timedOut;
    private final long timeInMS;
    private final Set<OverwriteInfo> sanitizerAndSinkOverwrites;

    public RawAnalysisResult(AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propagationGraph, ISupportGraph supportGraph, Set<Variable> propagationSeeds, Set<OverwriteInfo> sanitizer_and_sink_overwrites, long timeInMS, boolean timedOut) {
        this.propagationGraph = propagationGraph;
        this.supportGraph = supportGraph;
        this.propagationSeeds = propagationSeeds;
        this.sanitizerAndSinkOverwrites = sanitizer_and_sink_overwrites;
        this.timeInMS = timeInMS;
        this.timedOut = timedOut;
    }

    public RawAnalysisResult(AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propagationGraph, ISupportGraph supportGraph, Set<Variable> propagationSeeds, Set<OverwriteInfo> sanitizer_and_sink_overwrites) {
        this.propagationGraph = propagationGraph;
        this.supportGraph = supportGraph;
        this.propagationSeeds = propagationSeeds;
        this.sanitizerAndSinkOverwrites = sanitizer_and_sink_overwrites;
        this.timeInMS = -1L;
        this.timedOut = false;
    }

    public RawAnalysisResult(AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propagationGraph, ISupportGraph supportGraph, Set<Variable> propagationSeeds, long timeInMS, boolean timedOut) {
        this.propagationGraph = propagationGraph;
        this.supportGraph = supportGraph;
        this.propagationSeeds = propagationSeeds;
        this.sanitizerAndSinkOverwrites = HashSetFactory.make();
        this.timeInMS = timeInMS;
        this.timedOut = timedOut;
    }

    public RawAnalysisResult(AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propagationGraph, ISupportGraph supportGraph, Set<Variable> propagationSeeds) {
        this.propagationGraph = propagationGraph;
        this.supportGraph = supportGraph;
        this.propagationSeeds = propagationSeeds;
        this.sanitizerAndSinkOverwrites = HashSetFactory.make();
        this.timeInMS = -1L;
        this.timedOut = false;
    }

    public Set<OverwriteInfo> getSanitizerAndSinkOverwrites() {
        return this.sanitizerAndSinkOverwrites;
    }

    public Set<Variable> getPropagationSeeds() {
        return this.propagationSeeds;
    }

    public ISupportGraph getSupportGraph() {
        return this.supportGraph;
    }

    public AbstractNumberedLabeledGraph<Variable, IPropagationWitness> getPropagationGraph() {
        return this.propagationGraph;
    }

    public boolean getTimedOut() {
        return this.timedOut;
    }

    public long getTimeInMS() {
        return this.timeInMS;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propagationGraph == null ? 0 : this.propagationGraph.hashCode());
        result = 31 * result + (this.propagationSeeds == null ? 0 : this.propagationSeeds.hashCode());
        result = 31 * result + (this.sanitizerAndSinkOverwrites == null ? 0 : this.sanitizerAndSinkOverwrites.hashCode());
        result = 31 * result + (this.supportGraph == null ? 0 : this.supportGraph.hashCode());
        result = 31 * result + (int)(this.timeInMS ^ this.timeInMS >>> 32);
        result = 31 * result + (this.timedOut ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawAnalysisResult other = (RawAnalysisResult)obj;
        if (this.propagationGraph == null ? other.propagationGraph != null : !this.propagationGraph.equals(other.propagationGraph)) {
            return false;
        }
        if (this.propagationSeeds == null ? other.propagationSeeds != null : !this.propagationSeeds.equals(other.propagationSeeds)) {
            return false;
        }
        if (this.sanitizerAndSinkOverwrites == null ? other.sanitizerAndSinkOverwrites != null : !this.sanitizerAndSinkOverwrites.equals(other.sanitizerAndSinkOverwrites)) {
            return false;
        }
        if (this.supportGraph == null ? other.supportGraph != null : !this.supportGraph.equals(other.supportGraph)) {
            return false;
        }
        if (this.timeInMS != other.timeInMS) {
            return false;
        }
        return this.timedOut == other.timedOut;
    }
}

