/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.harness;

import com.ibm.wala.andromeda.rules.FlowStep;
import com.ibm.wala.andromeda.rules.ITaintResult;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CompareResults {
    public static void main(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException {
        if (args.length != 2) {
            System.out.println("Please pass in the two files you want to compare");
            return;
        }
        String[] fileNames = new String[]{args[0], args[1]};
        LinkedList<HashSet> results = new LinkedList<HashSet>();
        for (String filename : fileNames) {
            File file = new File(filename);
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            Set r = (Set)in.readObject();
            if (!(r instanceof HashSet)) {
                r = HashSetFactory.make((Collection)r);
            }
            results.add((HashSet)r);
            in.close();
        }
        HashSet r1 = (HashSet)results.get(0);
        HashSet r2 = (HashSet)results.get(1);
        CompareResults.printDisjointComparisonToConsole(r1, r2);
    }

    public static ComparisonResult compare(Set<ITaintResult> r1, Set<ITaintResult> r2) {
        HashSet rr1 = HashSetFactory.make((int)r1.size());
        for (ITaintResult iTaintResult : r1) {
            rr1.add(new TaintResultWrapper(iTaintResult));
        }
        HashSet rr2 = HashSetFactory.make((int)r2.size());
        for (ITaintResult r : r2) {
            rr2.add(new TaintResultWrapper(r));
        }
        HashSet hashSet = (HashSet)rr1.clone();
        HashSet r2_clone = (HashSet)rr2.clone();
        rr1.removeAll(r2_clone);
        rr2.removeAll(hashSet);
        hashSet.retainAll(r2_clone);
        ComparisonResult res = new ComparisonResult(rr1.size(), rr2.size(), hashSet.size());
        return res;
    }

    private static void printDisjointComparisonToConsole(HashSet<ITaintResult> r1, HashSet<ITaintResult> r2) {
        System.out.println("Size of r1: " + r1.size());
        System.out.println("Size of r2: " + r2.size());
        System.out.println();
        HashSet rr1 = HashSetFactory.make((int)r1.size());
        for (ITaintResult r : r1) {
            rr1.add(new TaintResultWrapper(r));
        }
        HashSet rr1_clone = (HashSet)rr1.clone();
        HashSet rr2 = HashSetFactory.make((int)r2.size());
        for (ITaintResult r : r2) {
            rr2.add(new TaintResultWrapper(r));
        }
        HashSet rr2_clone = (HashSet)rr2.clone();
        rr1.removeAll(rr2_clone);
        rr2.removeAll(rr1_clone);
        System.out.println("Items in r1 but not r2:");
        for (TaintResultWrapper r : rr1) {
            System.out.println(r.res);
            System.out.println();
        }
        System.out.println();
        System.out.println("============================================================");
        System.out.println("============================================================");
        System.out.println();
        System.out.println("Items in r2 but not r1:");
        for (TaintResultWrapper r : rr2) {
            System.out.println(r.res);
            System.out.println();
        }
    }

    static class TaintResultWrapper {
        private final ITaintResult res;

        public TaintResultWrapper(ITaintResult res) {
            this.res = res;
        }

        public int hashCode() {
            int result = 0;
            for (int idx = 0; idx < this.res.getFlow().size(); ++idx) {
                FlowStep step = this.res.getFlow().get(idx);
                if (step.getLineNumber() == 1) continue;
                result += step.hashCode();
                if (step.getDescriptor().equals(this.res.getLibraryCallPoint()) && step.getLineNumber() == this.res.getLineNo()) break;
            }
            return result += this.res.getRule().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TaintResultWrapper) {
                TaintResultWrapper other = (TaintResultWrapper)obj;
                if (this.res.getLineNo() != other.res.getLineNo()) {
                    return false;
                }
                if (!this.res.getLibraryCallPoint().equals(other.res.getLibraryCallPoint())) {
                    return false;
                }
                if (!this.res.getRule().equals(other.res.getRule())) {
                    return false;
                }
                List<FlowStep> f1 = this.clean(this.res.getFlow());
                List<FlowStep> f2 = this.clean(other.res.getFlow());
                for (int idx = 0; idx < Math.min(f1.size(), f2.size()); ++idx) {
                    FlowStep otherFlowStep;
                    FlowStep flowStep = f1.get(idx);
                    if (!flowStep.equals(otherFlowStep = f2.get(idx))) {
                        return false;
                    }
                    if (!flowStep.getDescriptor().equals(this.res.getLibraryCallPoint()) || flowStep.getLineNumber() != this.res.getLineNo()) continue;
                    return otherFlowStep.getDescriptor().equals(this.res.getLibraryCallPoint()) && otherFlowStep.getLineNumber() == this.res.getLineNo();
                }
            }
            return false;
        }

        private List<FlowStep> clean(List<FlowStep> flow) {
            ArrayList<FlowStep> result = new ArrayList<FlowStep>(flow.size());
            for (int i = 0; i < flow.size(); ++i) {
                if (flow.get(i).getLineNumber() == 1) continue;
                result.add(flow.get(i));
            }
            return result;
        }
    }

    public static class ComparisonResult {
        public final int onlyInLhs;
        public final int onlyInRhs;
        public final int inBoth;

        public ComparisonResult(int onlyInLhs, int onlyInRhs, int inBoth) {
            this.onlyInLhs = onlyInLhs;
            this.onlyInRhs = onlyInRhs;
            this.inBoth = inBoth;
        }
    }
}

