/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.harness;

import com.ibm.wala.andromeda.harness.AbstractTaintRule;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.andromeda.rules.management.Method;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TaintRule
extends AbstractTaintRule {
    private final IRawTaintRule declarativeRule;

    @Override
    public String toString() {
        return "TaintRule [declarativeRule=" + this.declarativeRule + "]";
    }

    protected TaintRule(IClassHierarchy cha, IRawTaintRule declarativeRule, Collection<MethodReference> sources, Collection<MethodReference> sinks, Collection<MethodReference> sanitizers) {
        super(cha);
        this.declarativeRule = declarativeRule;
        this.init(sources, sanitizers, sinks);
    }

    public TaintRule(IClassHierarchy cha, IRawTaintRule declarativeRule) {
        super(cha);
        Method m;
        this.declarativeRule = declarativeRule;
        HashSet sources = HashSetFactory.make();
        HashSet sinks = HashSetFactory.make();
        HashSet sanitizers = HashSetFactory.make();
        for (IMember cp : declarativeRule.getSources()) {
            if (!(cp instanceof Method)) continue;
            m = (Method)cp;
            sources.addAll(TaintRule.findOrCreateMethodReferences(m, cha));
        }
        for (IMember cp : declarativeRule.getSinks()) {
            if (!(cp instanceof Method)) continue;
            m = (Method)cp;
            sinks.addAll(TaintRule.findOrCreateMethodReferences(m, cha));
        }
        for (IMember cp : declarativeRule.getSanitizers()) {
            if (!(cp instanceof Method)) continue;
            m = (Method)cp;
            sanitizers.addAll(TaintRule.findOrCreateMethodReferences(m, cha));
        }
        this.init(sources, sanitizers, sinks);
    }

    protected void init(Collection<MethodReference> sources, Collection<MethodReference> sanitizers, Collection<MethodReference> sinks) {
        Set range;
        for (MethodReference mr : sources) {
            if (mr.getReturnType().equals((Object)TypeReference.Void)) continue;
            this.sourceRefs.add(mr);
            range = MapUtil.findOrCreateSet((Map)this.sourceMethodResolutionMap, (Object)mr.getSelector());
            range.add(this.cha.lookupClass(mr.getDeclaringClass()));
        }
        for (MethodReference mr : sanitizers) {
            if (mr.getNumberOfParameters() <= 0) continue;
            this.sanitizerRefs.add(mr);
            range = MapUtil.findOrCreateSet((Map)this.sanitizerMethodResolutionMap, (Object)mr.getSelector());
            range.add(this.cha.lookupClass(mr.getDeclaringClass()));
        }
        for (MethodReference mr : sinks) {
            if (mr.getNumberOfParameters() <= 0) continue;
            this.sinkRefs.add(mr);
            range = MapUtil.findOrCreateSet((Map)this.sinkMethodResolutionMap, (Object)mr.getSelector());
            range.add(this.cha.lookupClass(mr.getDeclaringClass()));
        }
    }

    public IRawTaintRule getDeclarativeRule() {
        return this.declarativeRule;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection<MethodReference> findOrCreateMethodReferences(Method m, IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        String sig = m.getSignature();
        IClass klass = TaintRule.getDeclaringClass(sig, cha);
        if (klass == null) return result;
        if (TaintRule.isPartialSig(sig)) {
            String methodName = sig.substring(sig.lastIndexOf(46) + 1, sig.length());
            Collection methods = null;
            methods = klass.getDeclaredMethods();
            if (methods != null) {
                for (IMethod method : methods) {
                    if (!method.getName().toString().equals(methodName)) continue;
                    result.add(method.getReference());
                }
            }
            if (result.isEmpty() && (methods = klass.getDeclaredMethods()) != null) {
                for (IMethod method : methods) {
                    if (!method.getName().toString().equals(methodName)) continue;
                    result.add(method.getReference());
                }
            }
            if (!result.isEmpty()) return result;
        }
        MethodReference mr = TaintRule.findOrCreateMethodReference(klass, m);
        if (mr == null) return result;
        result.add(mr);
        return result;
    }

    private static IClass getDeclaringClass(String sig, IClassHierarchy cha) {
        String declaringClass = sig.substring(0, sig.lastIndexOf(46));
        declaringClass = StringStuff.deployment2CanonicalTypeString((String)declaringClass);
        for (IClassLoader l : cha.getLoaders()) {
            IClass klass;
            if (!cha.getScope().isApplicationLoader(l) || (klass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)l.getReference(), (String)declaringClass))) == null) continue;
            return klass;
        }
        return null;
    }

    private static boolean isPartialSig(String sig) {
        return !sig.contains("(");
    }

    private static MethodReference findOrCreateMethodReference(IClass c, Method m) {
        int paren;
        String typeAndName;
        int lastDot;
        String methodSig = m.getSignature();
        String selector = methodSig.substring((lastDot = (typeAndName = methodSig.substring(0, paren = methodSig.indexOf(40))).lastIndexOf(46)) + 1);
        Selector s = TaintRule.toSelector(selector);
        IMethod method = c.getMethod(s);
        return method == null ? null : method.getReference();
    }

    private static Selector toSelector(String s) {
        String name = s.substring(0, s.indexOf(40));
        String desc = s.substring(s.indexOf(40));
        Descriptor d = Descriptor.findOrCreateUTF8((String)desc);
        return new Selector(Atom.findOrCreateUnicodeAtom((String)name), d);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cha == null ? 0 : this.cha.hashCode());
        result = 31 * result + (this.declarativeRule == null ? 0 : this.declarativeRule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaintRule other = (TaintRule)obj;
        if (this.cha == null ? other.cha != null : !this.cha.equals(other.cha)) {
            return false;
        }
        return !(this.declarativeRule == null ? other.declarativeRule != null : !this.declarativeRule.equals(other.declarativeRule));
    }
}

