/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.incremental;

import com.ibm.wala.andromeda.incremental.BoundedSupportGraph;
import com.ibm.wala.andromeda.incremental.ISupportGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Map;

public class BoundedDepthSupportGraph
extends BoundedSupportGraph {
    private static final int DEFAULT_BUDGET = 3;
    private final int budget;
    private final Map<IMethod, Integer> whitelist = HashMapFactory.make();

    public BoundedDepthSupportGraph(int budget) {
        this.budget = budget;
    }

    public BoundedDepthSupportGraph() {
        this(3);
    }

    @Override
    public boolean addSupport(ISupportGraph.Fact from, ISupportGraph.Fact to) {
        Integer fromValue = this.getWhitelistValue(from);
        if (fromValue <= this.budget) {
            this.setWhitelistValue(to, fromValue + 1);
            this.underlyingGraph.addSupport(from, to);
            return true;
        }
        return false;
    }

    private void setWhitelistValue(ISupportGraph.Fact f, int i) {
        Integer value;
        IMethod bindings = f.getBindings();
        if (!bindings.getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application) && ((value = this.whitelist.get(bindings)) == null || value != null && value > i)) {
            this.whitelist.put(f.getBindings(), i);
        }
    }

    private Integer getWhitelistValue(ISupportGraph.Fact f) {
        Integer result = 0;
        IMethod bindings = f.getBindings();
        ClassLoaderReference loader = bindings.getDeclaringClass().getClassLoader().getReference();
        if (!loader.equals((Object)ClassLoaderReference.Application)) {
            result = this.whitelist.get(bindings);
        }
        if (result == null) {
            result = 1;
        }
        return result;
    }
}

