/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.modular;

import com.ibm.wala.andromeda.modular.ISinkId;
import com.ibm.wala.andromeda.modular.ISourceId;
import com.ibm.wala.andromeda.modular.ISourceSinksMappings;
import com.ibm.wala.andromeda.modular.SigSinkId;
import com.ibm.wala.andromeda.modular.SigSourceId;
import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class SourceSinksMappings
implements ISourceSinksMappings,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<ISourceId, IMember> sourceCodePatternMap = HashMapFactory.make();
    private final Map<ISinkId, IMember> sinkCodePatternMap = HashMapFactory.make();

    public SourceSinksMappings(Set<IMember> sourceCodePatterns, Set<IMember> sinkCodePatterns) {
        for (IMember source : sourceCodePatterns) {
            this.sourceCodePatternMap.put(new SigSourceId(source.getPattern()), source);
        }
        for (IMember sink : sinkCodePatterns) {
            this.sinkCodePatternMap.put(new SigSinkId(sink.getPattern()), sink);
        }
    }

    @Override
    public Map<ISourceId, IMember> getSourceCodePatternMap() {
        return this.sourceCodePatternMap;
    }

    @Override
    public Map<ISinkId, IMember> getSinkCodePatternMap() {
        return this.sinkCodePatternMap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("sources:\n");
        for (Map.Entry<ISourceId, IMember> entry : this.sourceCodePatternMap.entrySet()) {
            sb.append("\t");
            sb.append(entry);
            sb.append("\n");
        }
        sb.append("sinks:\n");
        for (Map.Entry<Comparable<ISourceId>, IMember> entry : this.sinkCodePatternMap.entrySet()) {
            sb.append("\t");
            sb.append(entry);
            sb.append("\n");
        }
        return sb.toString();
    }
}

