/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.rules;

import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.RawTaintRule;
import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.andromeda.rules.management.Issue;
import com.ibm.wala.andromeda.rules.management.RuleContext;
import com.ibm.wala.andromeda.rules.management.RuleManager;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.andromeda.util.scopes.Projects;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Rules {
    private static Set<IRawTaintRule> regressionRules;
    private static Set<IRawTaintRule> allJavaRules;
    private static Set<IRawTaintRule> allDotNetRules;
    private static Set<IRawTaintRule> allJavaScriptRules;
    private static Set<IRawTaintRule> defaultJavaRules;
    private static Set<IRawTaintRule> defaultDotNetRules;
    private static final String IL_JS_RULES_PATH = "resources/rules_js.xml";
    private static final String OZ_JS_RULES_PATH = "resources/ASSE_rules_js.xml";
    private static final String SPECIAL_JS_RULES_PATH = "resources/special_rules_js.xml";
    private static String javaScriptRulesPath;
    private static String javaScriptSpecialRulesPath;

    public static Collection<IClass> getCommonSourceClasses(IClassHierarchy cha) {
        HashSet sourceClasses = HashSetFactory.make();
        for (String sourceSig : Rules.getCommonSources()) {
            IClass c = SignatureUtil.getDeclaringClass((String)sourceSig, (IClassHierarchy)cha);
            if (c == null) continue;
            sourceClasses.add(c);
        }
        return sourceClasses;
    }

    public static Set<IRawTaintRule> createInstantRules(String src, String sink) {
        return Rules.createInstantRules(Collections.singleton(src), Collections.singleton(sink), Collections.emptySet());
    }

    public static Set<IRawTaintRule> createInstantRules(String src, String sink, String issueID, String ruleName) {
        return Rules.createInstantRules(Collections.singleton(src), Collections.singleton(sink), Collections.emptySet(), issueID, ruleName);
    }

    public static Set<IRawTaintRule> createInstantRules(String src, String sink, String sanitizer, String issueID, String ruleName) {
        return Rules.createInstantRules(Collections.singleton(src), Collections.singleton(sink), Collections.singleton(sanitizer), issueID, ruleName);
    }

    public static Set<IRawTaintRule> createInstantRules(String src, String sink, String sanitizer) {
        return Rules.createInstantRules(Collections.singleton(src), Collections.singleton(sink), Collections.singleton(sanitizer));
    }

    public static Set<IRawTaintRule> createInstantRules(Collection<String> sources, Collection<String> sinks, Collection<String> sanitizers) {
        return Rules.createInstantRules(sources, sinks, sanitizers, null);
    }

    public static Set<IRawTaintRule> createInstantRules(Collection<String> sources, Collection<String> sinks, Collection<String> sanitizers, String issueID) {
        RawTaintRule r = new RawTaintRule("instant" + System.currentTimeMillis(), sources, sinks, sanitizers, RuleContext.RegressionContext, issueID);
        HashSet<IRawTaintRule> rules = new HashSet<IRawTaintRule>(1);
        rules.add(r);
        return rules;
    }

    public static Set<IRawTaintRule> createInstantRules(Collection<String> sources, Collection<String> sinks, Collection<String> sanitizers, String issueID, String ruleName) {
        RawTaintRule r = new RawTaintRule(ruleName, sources, sinks, sanitizers, RuleContext.RegressionContext, issueID);
        HashSet<IRawTaintRule> rules = new HashSet<IRawTaintRule>(1);
        rules.add(r);
        return rules;
    }

    public static Collection<String> getCommonSources() {
        HashSet sources = HashSetFactory.make();
        sources.add("javax.servlet.http.HttpServletRequest.getCookies()[Ljavax/servlet/http/Cookie;");
        sources.add("javax.servlet.http.HttpServletRequest.getAuthType()Ljava/lang/String;");
        sources.add("javax.servlet.http.HttpServletRequest.getHeader(Ljava/lang/String;)Ljava/lang/String;");
        sources.add("javax.servlet.http.HttpServletRequest.getHeaders(Ljava/lang/String;)Ljava/util/Enumeration;");
        sources.add("javax.servlet.http.HttpServletRequest.getHeaderNames()Ljava/util/Enumeration;");
        sources.add("javax.servlet.http.HttpServletRequest.getPathInfo()Ljava/lang/String;");
        sources.add("javax.servlet.http.HttpServletRequest.getQueryString()Ljava/lang/String;");
        sources.add("javax.servlet.http.HttpServletRequest.getRemoteUser()Ljava/lang/String;");
        sources.add("javax.servlet.http.HttpServletRequest.getRequestURI()Ljava/lang/String;");
        sources.add("javax.servlet.ServletConfig.getInitParameter(Ljava/lang/String;)Ljava/lang/String;");
        sources.add("javax.servlet.ServletConfig.getInitParameterNames()Ljava/util/Enumeration;");
        sources.add("javax.servlet.ServletContext.getInitParameter(Ljava/lang/String;)Ljava/lang/String;");
        sources.add("javax.servlet.ServletRequest.getAttributeNames()Ljava/util/Enumeration;");
        sources.add("javax.servlet.ServletRequest.getContentType()Ljava/lang/String;");
        sources.add("javax.servlet.ServletRequest.getInputStream()Ljavax/servlet/ServletInputStream;");
        sources.add("javax.servlet.ServletRequest.getParameter(Ljava/lang/String;)Ljava/lang/String;");
        sources.add("javax.servlet.ServletRequest.getParameterMap()Ljava/util/Map;");
        sources.add("javax.servlet.ServletRequest.getParameterValues(Ljava/lang/String;)[Ljava/lang/String;");
        sources.add("javax.servlet.ServletRequest.getProtocol()Ljava/lang/String;");
        sources.add("javax.servlet.ServletRequest.getScheme()Ljava/lang/String;");
        return sources;
    }

    public static Set<IRawTaintRule> getRulesForRegression() {
        return regressionRules;
    }

    public static String getDotNetRulesPath() {
        return "actual_rules_dotnet.xml";
    }

    public static String getJavaRulesPath() {
        return "resources/rules_java.xml";
    }

    public static String getJavaScriptRulesPath() {
        return javaScriptRulesPath;
    }

    public static String getJavaScriptSpecialRulesPath() {
        return javaScriptSpecialRulesPath;
    }

    public static void setJavaScriptRulesPath(String path) {
        javaScriptRulesPath = path;
    }

    public static void setJavaScriptSpecialRulesPath(String jsSpecialRulesPath) {
        javaScriptSpecialRulesPath = jsSpecialRulesPath;
    }

    public static synchronized Set<IRawTaintRule> getAllDotNetRules() {
        if (allDotNetRules == null) {
            RuleManager ruleManager = RuleManager.getRuleManager(Rules.getDotNetRulesPath());
            allDotNetRules = ruleManager.getRules();
        }
        return allDotNetRules;
    }

    public static synchronized Set<IRawTaintRule> getAllJavaRules() {
        return Rules.getAllJavaRules("");
    }

    public static synchronized Set<IRawTaintRule> getAllJavaRules(String prefix) {
        if (allJavaRules == null) {
            RuleManager ruleManager = RuleManager.getRuleManager(prefix + Rules.getJavaRulesPath());
            allJavaRules = ruleManager.getRules();
        }
        return allJavaRules;
    }

    public static synchronized Set<IRawTaintRule> getAllJavaScriptRules() {
        if (allJavaScriptRules == null) {
            RuleManager ruleManager = RuleManager.getRuleManager(Rules.getJavaScriptRulesPath());
            allJavaScriptRules = ruleManager.getRules();
        }
        return allJavaScriptRules;
    }

    public static synchronized Set<IRawTaintRule> getDefaultDotNetRules() {
        if (defaultDotNetRules == null) {
            RuleManager ruleManager = RuleManager.getRuleManager(Rules.getDotNetRulesPath());
            defaultDotNetRules = Rules.getDefaultRules(ruleManager, Rules.getAllDotNetRules());
        }
        return defaultDotNetRules;
    }

    public static synchronized Set<IRawTaintRule> getDefaultRules(RuleManager ruleManager, Set<IRawTaintRule> allRules) {
        HashSet result = HashSetFactory.make();
        for (IRawTaintRule rule : allRules) {
            Issue issue = ruleManager.getIssue(rule.getIssueID());
            int exploitability = rule.getExploitabilityLevel();
            int severity = issue.getSeverity();
            if (exploitability != 0 || severity >= 4) continue;
            result.add(rule);
        }
        return result;
    }

    public static synchronized Set<IRawTaintRule> getDefaultJavaRules() {
        if (defaultJavaRules == null) {
            RuleManager ruleManager = RuleManager.getRuleManager(Rules.getJavaRulesPath());
            defaultJavaRules = Rules.getDefaultRules(ruleManager, Rules.getAllJavaRules());
        }
        return defaultJavaRules;
    }

    public static IRawTaintRule getRuleXSS() {
        Collection<String> sources = Rules.getCommonSources();
        ArrayList<String> sinks = new ArrayList<String>();
        ArrayList<String> sanitizers = new ArrayList<String>();
        Set<String> illegalPatterns = Collections.singleton(".*<[sS][cC][rR][iI][pP][tT].*");
        sinks.add("java.io.PrintWriter.print(I)V");
        sinks.add("java.io.PrintWriter.print(Ljava/lang/Object;)V");
        sinks.add("java.io.PrintWriter.print(Ljava/lang/String;)V");
        sinks.add("java.io.PrintWriter.println(I)V");
        sinks.add("java.io.PrintWriter.println(Ljava/lang/Object;)V");
        sinks.add("java.io.PrintWriter.println(Ljava/lang/String;)V");
        sinks.add("java.io.PrintWriter.write(I)V");
        sinks.add("java.io.PrintWriter.write(Ljava/lang/String;)V");
        sinks.add("java.io.PrintStream.write(Ljava/lang/String;)V");
        sinks.add("java.io.PrintStream.print(Ljava/lang/Object;)V");
        sinks.add("java.io.PrintStream.print(Ljava/lang/String;)V");
        sinks.add("java.io.PrintStream.println(Ljava/lang/Object;)V");
        sinks.add("java.io.PrintStream.println(Ljava/lang/String;)V");
        sinks.add("java.util.zip.GZIPOutputStream.write([BII)V");
        sinks.add("javax.servlet.ServletOutputStream.print(Ljava/lang/String;)V");
        sinks.add("javax.servlet.ServletOutputStream.println(Ljava/lang/String;)V");
        sinks.add("javax.servlet.jsp.JspWriter.print(Ljava/lang/Object;)V");
        sinks.add("javax.servlet.jsp.JspWriter.print(Ljava/lang/String;)V");
        sinks.add("javax.servlet.jsp.JspWriter.println(Ljava/lang/Object;)V");
        sinks.add("javax.servlet.jsp.JspWriter.println(Ljava/lang/String;)V");
        return new RawTaintRule("XSS", sources, sinks, sanitizers, RuleContext.RegressionContext, illegalPatterns);
    }

    public static IRawTaintRule getRuleSQLi() {
        Collection<String> sources = Rules.getCommonSources();
        ArrayList<String> sinks = new ArrayList<String>();
        ArrayList<String> sanitizers = new ArrayList<String>();
        Set<String> illegalPatterns = Collections.singleton(".*'.*");
        sinks.add("java.sql.Statement.addBatch(Ljava/lang/String;)V");
        sinks.add("java.sql.Statement.execute(Ljava/lang/String;)Z");
        sinks.add("java.sql.Statement.execute(Ljava/lang/String;I)Z");
        sinks.add("java.sql.Statement.execute(Ljava/lang/String;[I)Z");
        sinks.add("java.sql.Statement.executeUpdate(Ljava/lang/String;)I");
        sinks.add("java.sql.Statement.executeUpdate(Ljava/lang/String;I)I");
        sinks.add("java.sql.Statement.executeUpdate(Ljava/lang/String;[Ljava/lang/String;)I");
        sinks.add("java.sql.Statement.executeQuery(Ljava/lang/String;)Ljava/sql/ResultSet;");
        sinks.add("java.sql.Connection.prepareStatement(Ljava/lang/String;)Ljava/sql/PreparedStatement;");
        sinks.add("java.sql.Connection.prepareStatement(Ljava/lang/String;I)Ljava/sql/PreparedStatement;");
        sinks.add("java.sql.Connection.prepareStatement(Ljava/lang/String;II)Ljava/sql/PreparedStatement;");
        sinks.add("java.sql.Connection.prepareStatement(Ljava/lang/String;III)Ljava/sql/PreparedStatement;");
        sinks.add("java.sql.Connection.prepareStatement(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;");
        sinks.add("java.sql.Connection.prepareStatement(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;");
        sinks.add("java.sql.Connection.prepareCall(Ljava/lang/String;)Ljava/sql/CallableStatement;");
        sinks.add("java.sql.Connection.prepareCall(Ljava/lang/String;II)Ljava/sql/CallableStatement;");
        sinks.add("java.sql.Connection.prepareCall(Ljava/lang/String;III)Ljava/sql/CallableStatement;");
        return new RawTaintRule("SQLi", sources, sinks, sanitizers, RuleContext.RegressionContext, illegalPatterns);
    }

    public static IRawTaintRule getRuleHTTPRS() {
        Collection<String> sources = Rules.getCommonSources();
        ArrayList<String> sinks = new ArrayList<String>();
        ArrayList<String> sanitizers = new ArrayList<String>();
        sinks.add("javax.servlet.http.HttpServletResponse.sendRedirect(Ljava/lang/String;)V");
        return new RawTaintRule("HTTPRS", sources, sinks, sanitizers, RuleContext.RegressionContext);
    }

    public static IRawTaintRule getRulePathTraversal() {
        Collection<String> sources = Rules.getCommonSources();
        ArrayList<String> sinks = new ArrayList<String>();
        ArrayList<String> sanitizers = new ArrayList<String>();
        sinks.add("java.io.JarFile.<init>(Ljava/lang/String;)V");
        sinks.add("java.io.JarFile.<init>(Ljava/lang/String;Z)V");
        sinks.add("java.io.JarFile.<init>(Ljava/io/File;)V");
        sinks.add("java.io.JarFile.<init>(Ljava/io/File;Z)V");
        sinks.add("java.io.JarFile.<init>(Ljava/io/File;ZI)V");
        sinks.add("java.io.File.<init>(Ljava/lang/String;)V");
        sinks.add("java.io.File.<init>(Ljava/lang/String;Ljava/lang/String;)V");
        sinks.add("java.io.File.<init>(Ljava/io/File;Ljava/lang/String;)V");
        sinks.add("java.io.RandomAccessFile.<init>(Ljava/lang/String;Ljava/lang/String;)V");
        sinks.add("java.io.FileReader.<init>(Ljava/lang/String;)V");
        sinks.add("java.io.FileWriter.<init>(Ljava/lang/String;)V");
        sinks.add("java.io.FileInputStream.<init>(Ljava/lang/String;)V");
        sinks.add("java.io.FileOutputStream.<init>(Ljava/lang/String;)V");
        return new RawTaintRule("PathTraversal", sources, sinks, sanitizers, RuleContext.RegressionContext);
    }

    public static IRawTaintRule getRuleCommandInjection() {
        Collection<String> sources = Rules.getCommonSources();
        ArrayList<String> sinks = new ArrayList<String>();
        ArrayList<String> sanitizers = new ArrayList<String>();
        sinks.add("java.lang.Runtime.exec(Ljava/lang/String;)Ljava/lang/Process;");
        sinks.add("java.lang.Runtime.exec([Ljava/lang/String;)Ljava/lang/Process;");
        sinks.add("java.lang.Runtime.exec(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Process;");
        sinks.add("java.lang.Runtime.exec([Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Process;");
        sinks.add("java.lang.Runtime.exec([Ljava/lang/String;[Ljava/lang/String;Ljava/io/File;)Ljava/lang/Process;");
        return new RawTaintRule("CommandInjection", sources, sinks, sanitizers, RuleContext.RegressionContext);
    }

    public static IRawTaintRule getRuleTrustBoundaryViolation() {
        Collection<String> sources = Rules.getCommonSources();
        ArrayList<String> sinks = new ArrayList<String>();
        ArrayList<String> sanitizers = new ArrayList<String>();
        sinks.add("javax.servlet.ServletRequest.setAttribute(Ljava/lang/String;Ljava/lang/Object;)V");
        sinks.add("javax.servlet.http.HttpSession.setAttribute(Ljava/lang/String;Ljava/lang/Object;)V");
        sinks.add("javax.servlet.http.HttpSession.removeAttribute(Ljava/lang/String;)V");
        sinks.add("java.lang.Class.forName(Ljava/lang/String;)Ljava/lang/Class;");
        sinks.add("java.lang.reflect.Method(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        sinks.add("javax.servlet.http.HttpServletResponse.addCookie(Ljavax/servlet/http/Cookie;)V");
        sinks.add("java.lang.System.setProperty(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        sinks.add("java.net.URI.<init>(Ljava/lang/String;)V");
        sinks.add("java.net.URL.<init>(Ljava/lang/String;)V");
        sinks.add("java.net.URL.<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        sinks.add("java.net.URL.<init>(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V");
        return new RawTaintRule("TrustBoundaryViolation", sources, sinks, sanitizers, RuleContext.RegressionContext);
    }

    public static IRawTaintRule getRuleExceptionDetails() {
        Collection<String> sources = Rules.getCommonSources();
        ArrayList<String> sinks = new ArrayList<String>();
        ArrayList<String> sanitizers = new ArrayList<String>();
        sources.add("java.lang.Throwable.getLocalizedMessage()Ljava/lang/String;");
        sources.add("java.lang.Throwable.getMessage()Ljava/lang/String;");
        sinks.add("java.io.PrintWriter.print(I)V");
        sinks.add("java.io.PrintWriter.print(Ljava/lang/Object;)V");
        sinks.add("java.io.PrintWriter.print(Ljava/lang/String;)V");
        sinks.add("java.io.PrintWriter.println(I)V");
        sinks.add("java.io.PrintWriter.println(Ljava/lang/Object;)V");
        sinks.add("java.io.PrintWriter.println(Ljava/lang/String;)V");
        sinks.add("java.io.PrintWriter.write(I)V");
        sinks.add("java.io.PrintWriter.write(Ljava/lang/String;)V");
        sinks.add("java.io.PrintStream.write(Ljava/lang/String;)V");
        sinks.add("java.io.PrintStream.print(Ljava/lang/Object;)V");
        sinks.add("java.io.PrintStream.print(Ljava/lang/String;)V");
        sinks.add("java.io.PrintStream.println(Ljava/lang/Object;)V");
        sinks.add("java.io.PrintStream.println(Ljava/lang/String;)V");
        return new RawTaintRule("ExceptionDetails", sources, sinks, sanitizers, RuleContext.RegressionContext);
    }

    public static IRawTaintRule getRuleLogging() {
        Collection<String> sources = Rules.getCommonSources();
        ArrayList<String> sinks = new ArrayList<String>();
        ArrayList<String> sanitizers = new ArrayList<String>();
        sources.add("java.lang.Throwable.getMessage()Ljava/lang/String;");
        sinks.add("javax.servlet.ServletContext.log(Ljava/lang/String;)V");
        sinks.add("javax.servlet.ServletContext.log(Ljava/lang/String;Ljava/lang/Throwable;)V");
        sinks.add("javax.servlet.ServletContext.log(Ljava/lang/Exception;Ljava/lang/String;)V");
        sinks.add("org.apache.commons.logging.Log.debug(Ljava/lang/Object;)V");
        sinks.add("org.apache.commons.logging.Log.error(Ljava/lang/Object;)V");
        sinks.add("org.apache.commons.logging.Log.fatal(Ljava/lang/Object;)V");
        sinks.add("org.apache.commons.logging.Log.info(Ljava/lang/Object;)V");
        sinks.add("org.apache.commons.logging.Log.trace(Ljava/lang/Object;)V");
        sinks.add("org.apache.commons.logging.Log.warn(Ljava/lang/Object;)V");
        sinks.add("org.apache.commons.logging.Log.debug(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.commons.logging.Log.error(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.commons.logging.Log.fatal(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.commons.logging.Log.info(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.commons.logging.Log.trace(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.commons.logging.Log.warn(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.log4j.Logger.debug(Ljava/lang/Object;)V");
        sinks.add("org.apache.log4j.Logger.error(Ljava/lang/Object;)V");
        sinks.add("org.apache.log4j.Logger.fatal(Ljava/lang/Object;)V");
        sinks.add("org.apache.log4j.Logger.info(Ljava/lang/Object;)V");
        sinks.add("org.apache.log4j.Logger.trace(Ljava/lang/Object;)V");
        sinks.add("org.apache.log4j.Logger.warn(Ljava/lang/Object;)V");
        sinks.add("org.apache.log4j.Logger.debug(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.log4j.Logger.error(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.log4j.Logger.fatal(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.log4j.Logger.info(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.log4j.Logger.trace(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("org.apache.log4j.Logger.warn(Ljava/lang/Object;Ljava/lang/Throwable;)V");
        sinks.add("java.util.logging.Logger.config(Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.entering(Ljava/lang/String;Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.entering(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V");
        sinks.add("java.util.logging.Logger.entering(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V");
        sinks.add("java.util.logging.Logger.exiting(Ljava/lang/String;Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.exiting(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V");
        sinks.add("java.util.logging.Logger.fine(Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.finer(Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.finest(Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.log(Ljava/util/logging/Level;Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.log(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/Object;)V");
        sinks.add("java.util.logging.Logger.log(Ljava/util/logging/Level;Ljava/lang/String;[Ljava/lang/Object;)V");
        sinks.add("java.util.logging.Logger.log(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/Throwable;)V");
        sinks.add("java.util.logging.Logger.log(Ljava/util/logging/LogRecord;)V");
        sinks.add("java.util.logging.Logger.logp(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.logp(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V");
        sinks.add("java.util.logging.Logger.logp(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V");
        sinks.add("java.util.logging.Logger.logp(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V");
        sinks.add("java.util.logging.Logger.logrb(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.logrb(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V");
        sinks.add("java.util.logging.Logger.logrb(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V");
        sinks.add("java.util.logging.Logger.logrb(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V");
        sinks.add("java.util.logging.Logger.severe(Ljava/lang/String;)V");
        sinks.add("java.util.logging.Logger.throwing(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V");
        sinks.add("java.util.logging.Logger.warning(Ljava/lang/String;)V");
        return new RawTaintRule("Logging", sources, sinks, sanitizers, RuleContext.RegressionContext);
    }

    public static IRawTaintRule getRuleDatabase() {
        HashSet sources = HashSetFactory.make(Rules.getCommonSources());
        Collection<String> sinks = Rules.getRuleXSS().getSinkSignatures();
        ArrayList<String> sanitizers = new ArrayList<String>();
        sources.add("java.sql.ResultSet.getString(I)Ljava/lang/String;");
        return new RawTaintRule("Database", sources, sinks, sanitizers, RuleContext.RegressionContext);
    }

    public static Set<IRawTaintRule> getAllRules(Projects.Language lang) {
        if (lang.equals((Object)Projects.Language.JAVA)) {
            return Rules.getAllJavaRules();
        }
        return Rules.getAllDotNetRules();
    }

    public static void getSourceAndSinkMembers(Set<IRawTaintRule> rules, Set<IMember> sourceMembers, Set<IMember> sinkMembers) {
        for (IRawTaintRule rule : rules) {
            sourceMembers.addAll(rule.getSources());
            sinkMembers.addAll(rule.getSinks());
        }
    }

    static {
        javaScriptRulesPath = OZ_JS_RULES_PATH;
        javaScriptSpecialRulesPath = SPECIAL_JS_RULES_PATH;
        regressionRules = HashSetFactory.make();
        regressionRules.add(Rules.getRuleXSS());
        regressionRules.add(Rules.getRuleSQLi());
        regressionRules.add(Rules.getRuleHTTPRS());
        regressionRules.add(Rules.getRulePathTraversal());
        regressionRules.add(Rules.getRuleCommandInjection());
        regressionRules.add(Rules.getRuleTrustBoundaryViolation());
        regressionRules.add(Rules.getRuleExceptionDetails());
        regressionRules.add(Rules.getRuleLogging());
        regressionRules.add(Rules.getRuleDatabase());
    }
}

