/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.containers.docker;

import com.ibm.appscan.common.utils.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class DockerManifestReader {
    private File m_file = null;
    private String m_config = null;
    private List<String> m_layers = null;
    private List<String> m_repoTags = null;

    public DockerManifestReader(File file) {
        this.m_file = file;
    }

    public String getConfig() throws IOException {
        if (this.m_config == null) {
            this.read();
        }
        return this.m_config;
    }

    public List<String> getLayers() throws IOException {
        if (this.m_layers == null) {
            this.read();
        }
        return this.m_layers;
    }

    public List<String> getRepoTags() throws IOException {
        if (this.m_repoTags == null) {
            this.read();
        }
        return this.m_repoTags;
    }

    private void read() throws IOException {
        this.m_layers = new ArrayList<String>();
        this.m_repoTags = new ArrayList<String>();
        FileReader reader = null;
        try {
            reader = new FileReader(this.m_file);
            JSONArray json = (JSONArray)JSON.parse((Reader)reader);
            JSONObject obj = json.getJSONObject(0);
            this.m_config = obj.getString("Config");
            JSONArray layers = obj.getJSONArray("Layers");
            for (int i = 0; i < layers.length(); ++i) {
                this.m_layers.add(layers.getString(i));
            }
            JSONArray repoTags = obj.getJSONArray("RepoTags");
            for (int i = 0; i < repoTags.length(); ++i) {
                this.m_repoTags.add(repoTags.getString(i));
            }
        }
        catch (FileNotFoundException | JSONException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)reader);
    }
}

