/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.containers.docker;

import com.hcl.appscan.discovery.containers.IContainerEngine;
import com.hcl.appscan.discovery.containers.Messages;
import com.hcl.appscan.discovery.containers.docker.DockerEngine;
import com.hcl.appscan.discovery.containers.docker.DockerManifestReader;
import com.hcl.appscan.discovery.containers.docker.IDockerHandler;
import com.hcl.appscan.discovery.containers.utils.TarUtils;
import com.hcl.appscan.internal.discovery.containers.docker.ImageHandler;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import java.io.File;
import java.io.IOException;

public class ImageArchiveHandler
implements IDockerHandler {
    private File m_archive;
    private IContainerEngine m_engine;
    private IProgress m_progress;
    private boolean m_loadedImage = false;

    public ImageArchiveHandler(String archive, IProgress progress) {
        this(archive, progress, new DockerEngine());
    }

    public ImageArchiveHandler(String archive, IProgress progress, IContainerEngine engine) {
        this.m_archive = new File(archive);
        this.m_progress = progress;
        this.m_engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getContainerArchive() throws AppScanException {
        File containerArchive = null;
        String imageName = null;
        try {
            imageName = this.getImageName();
            if (!this.m_engine.imageExists(imageName)) {
                this.m_progress.setStatus(new Message(1, Messages.DOCKER_LOAD));
                this.m_engine.loadImage(this.m_archive);
                this.m_loadedImage = true;
            } else {
                this.m_progress.setStatus(new Message(1, Messages.bind(Messages.DOCKER_IMAGE_EXISTS, imageName)));
            }
            ImageHandler handler = new ImageHandler(imageName, this.m_progress, this.m_engine);
            containerArchive = handler.getContainerArchive();
        }
        catch (AppScanException | IOException e) {
            this.handleException(this.m_progress, e, Messages.bind(Messages.ERROR_IMPORT_ARCHIVE, e.getMessage()));
        }
        finally {
            if (this.m_loadedImage) {
                this.removeImage(imageName);
            }
        }
        return containerArchive;
    }

    private String getImageName() throws IOException {
        File destintationDirectory = new File(CommonCore.getDirectoryLocator().getTemp());
        File manifest = TarUtils.getFileFromArchive(this.m_archive, destintationDirectory, "manifest.json");
        return new DockerManifestReader(manifest).getRepoTags().get(0);
    }

    private void removeImage(String imageName) {
        this.m_progress.setStatus(new Message(1, Messages.DOCKER_REMOVE_IMAGE));
        try {
            this.m_engine.removeImage(imageName);
        }
        catch (AppScanException | IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.bind(Messages.DOCKER_RMI_FAILED, imageName, e.getMessage())));
        }
    }
}

