/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.ContextItem;

public class CallString
implements ContextItem {
    private final CallSiteReference[] sites;
    private final IMethod[] methods;

    public CallString(CallSiteReference site, IMethod method) {
        if (site == null) {
            throw new IllegalArgumentException("null site");
        }
        this.sites = new CallSiteReference[]{site};
        this.methods = new IMethod[]{method};
    }

    CallString(CallSiteReference site, IMethod method, int length, CallString base) {
        int sitesLength = Math.min(length, base.sites.length + 1);
        int methodsLength = Math.min(length, base.methods.length + 1);
        this.sites = new CallSiteReference[sitesLength];
        this.sites[0] = site;
        System.arraycopy(base.sites, 0, this.sites, 1, Math.min(length - 1, base.sites.length));
        this.methods = new IMethod[methodsLength];
        this.methods[0] = method;
        System.arraycopy(base.methods, 0, this.methods, 1, Math.min(length - 1, base.methods.length));
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[");
        for (int i = 0; i < this.sites.length; ++i) {
            str.append(" ").append(this.methods[i].getSignature()).append("@").append(this.sites[i].getProgramCounter());
        }
        str.append(" ]");
        return str.toString();
    }

    public int hashCode() {
        int code = 1;
        for (int i = 0; i < this.sites.length; ++i) {
            code *= this.sites[i].hashCode() * this.methods[i].hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof CallString) {
            CallString oc = (CallString)o;
            if (oc.sites.length == this.sites.length) {
                for (int i = 0; i < this.sites.length; ++i) {
                    if (this.sites[i].equals(oc.sites[i]) && this.methods[i].equals(oc.methods[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public CallSiteReference[] getCallSiteRefs() {
        return this.sites;
    }

    public IMethod[] getMethods() {
        return this.methods;
    }
}

