/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.analysis.reflection.CloneInterpreter;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.rta.AbstractRTABuilder;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTASelectorKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;

public class BasicRTABuilder
extends AbstractRTABuilder {
    public BasicRTABuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache, ContextSelector contextSelector, SSAContextInterpreter contextInterpreter) {
        super(cha, options, cache, contextSelector, contextInterpreter);
    }

    @Override
    protected void updateSetsForNewClass(IClass klass, InstanceKey iKey, CGNode node, NewSiteReference n) {
        this.registerImplementedMethods(klass, iKey);
        for (IClass c : klass.getAllImplementedInterfaces()) {
            this.registerImplementedMethods(c, iKey);
        }
        for (klass = klass.getSuperclass(); klass != null; klass = klass.getSuperclass()) {
            this.registerImplementedMethods(klass, iKey);
        }
    }

    private void registerImplementedMethods(IClass declarer, InstanceKey iKey) {
        for (IMethod M : declarer.getDeclaredMethods()) {
            Selector selector = M.getReference().getSelector();
            RTASelectorKey sKey = this.getKeyForSelector(selector);
            this.system.newConstraint(sKey, iKey);
        }
    }

    @Override
    protected PointerKey getKeyForSite(CallSiteReference site) {
        return new RTASelectorKey(site.getDeclaredTarget().getSelector());
    }

    protected RTASelectorKey getKeyForSelector(Selector selector) {
        return new RTASelectorKey(selector);
    }

    @Override
    protected UnaryOperator<PointsToSetVariable> makeDispatchOperator(CallSiteReference site, CGNode node) {
        return new DispatchOperator(site, (ExplicitCallGraph.ExplicitNode)node);
    }

    private final class DispatchOperator
    extends UnaryOperator<PointsToSetVariable> {
        private final CallSiteReference site;
        private final ExplicitCallGraph.ExplicitNode caller;
        private final MutableIntSet previousReceivers = IntSetUtil.getDefaultIntSetFactory().make();

        DispatchOperator(CallSiteReference site, ExplicitCallGraph.ExplicitNode caller) {
            this.site = site;
            this.caller = caller;
        }

        public byte evaluate(PointsToSetVariable lhs, PointsToSetVariable rhs) {
            PointsToSetVariable receivers = rhs;
            MutableIntSet value = receivers.getValue();
            if (value == null) {
                return 0;
            }
            IClass recvClass = BasicRTABuilder.this.getClassHierarchy().lookupClass(this.site.getDeclaredTarget().getDeclaringClass());
            if (recvClass == null) {
                return 0;
            }
            value = BasicRTABuilder.this.filterForClass((IntSet)value, recvClass);
            IntSetAction action = new IntSetAction(){

                public void act(int ptr) {
                    InstanceKey iKey = BasicRTABuilder.this.system.getInstanceKey(ptr);
                    CGNode target = BasicRTABuilder.this.getTargetForCall(DispatchOperator.this.caller, DispatchOperator.this.site, iKey.getConcreteType(), new InstanceKey[]{iKey});
                    if (target == null) {
                        return;
                    }
                    if (target.getMethod().getReference().equals(CloneInterpreter.CLONE)) {
                        DispatchOperator.this.caller.addTarget(DispatchOperator.this.site, target);
                        return;
                    }
                    IntSet targets = BasicRTABuilder.this.getCallGraph().getPossibleTargetNumbers(DispatchOperator.this.caller, DispatchOperator.this.site);
                    if (targets != null && targets.contains(target.getGraphNodeId())) {
                        return;
                    }
                    BasicRTABuilder.this.processResolvedCall(DispatchOperator.this.caller, DispatchOperator.this.site, target);
                    if (!BasicRTABuilder.this.haveAlreadyVisited(target)) {
                        BasicRTABuilder.this.markDiscovered(target);
                    }
                }
            };
            value.foreachExcluding((IntSet)this.previousReceivers, action);
            this.previousReceivers.copySet((IntSet)value);
            return 0;
        }

        public String toString() {
            return "Dispatch";
        }

        public int hashCode() {
            return this.caller.hashCode() + 8707 * this.site.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DispatchOperator) {
                DispatchOperator other = (DispatchOperator)((Object)o);
                return this.caller.equals(other.caller) && this.site.equals(other.site);
            }
            return false;
        }
    }
}

