/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class MethodSummary {
    protected static final SSAInstruction[] NO_STATEMENTS = new SSAInstruction[0];
    private final MethodReference method;
    private ArrayList<SSAInstruction> statements;
    private Map<Integer, ConstantValue> constantValues;
    private int nextProgramCounter = 0;
    private String poison;
    private byte poisonLevel;
    private boolean isStatic = false;
    private boolean isFactory = false;

    public MethodSummary(MethodReference method) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        this.method = method;
    }

    public int getNumberOfStatements() {
        return this.statements == null ? 0 : this.statements.size();
    }

    public void addStatement(SSAInstruction statement) {
        if (this.statements == null) {
            this.statements = new ArrayList();
        }
        this.statements.add(statement);
    }

    public void addConstant(Integer vn, ConstantValue value) {
        if (this.constantValues == null) {
            this.constantValues = HashMapFactory.make((int)5);
        }
        this.constantValues.put(vn, value);
    }

    public MemberReference getMethod() {
        return this.method;
    }

    public boolean isNative() {
        return false;
    }

    public void addPoison(String reason) {
        this.poison = reason;
    }

    public boolean hasPoison() {
        return this.poison != null;
    }

    public String getPoison() {
        return this.poison;
    }

    public void setPoisonLevel(byte b) {
        this.poisonLevel = b;
        assert (b == 0 || b == 1 || b == 2);
    }

    public byte getPoisonLevel() {
        return this.poisonLevel;
    }

    public SSAInstruction[] getStatements() {
        if (this.statements == null) {
            return NO_STATEMENTS;
        }
        SSAInstruction[] result = new SSAInstruction[this.statements.size()];
        Iterator<SSAInstruction> it = this.statements.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = it.next();
        }
        return result;
    }

    public Map<Integer, ConstantValue> getConstants() {
        return this.constantValues;
    }

    public int getNumberOfParameters() {
        return this.isStatic() ? this.method.getNumberOfParameters() : this.method.getNumberOfParameters() + 1;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean b) {
        this.isStatic = b;
    }

    public TypeReference getReturnType() {
        return this.method.getReturnType();
    }

    public String toString() {
        return "[Summary: " + this.method + "]";
    }

    public TypeReference getParameterType(int i) {
        if (this.isStatic()) {
            return this.method.getParameterType(i);
        }
        if (i == 0) {
            return this.method.getDeclaringClass();
        }
        return this.method.getParameterType(i - 1);
    }

    public int getNextProgramCounter() {
        return this.nextProgramCounter++;
    }

    public void setFactory(boolean b) {
        this.isFactory = b;
    }

    public boolean isFactory() {
        return this.isFactory;
    }
}

