/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.generics.ClassTypeSignature;
import com.ibm.wala.types.generics.FormalTypeParameter;
import com.ibm.wala.types.generics.Signature;
import java.util.ArrayList;

public class ClassSignature
extends Signature {
    private ClassSignature(String sig) {
        super(sig);
    }

    public static ClassSignature make(String sig) {
        if (sig == null || sig.length() == 0) {
            throw new IllegalArgumentException("empty or null sig");
        }
        return new ClassSignature(sig);
    }

    public FormalTypeParameter[] getFormalTypeParameters() {
        if (this.rawString().charAt(0) != '<') {
            return null;
        }
        int index = this.endOfFormalTypeParameters();
        String[] args = FormalTypeParameter.parseForFormalTypeParameters(this.rawString().substring(0, index));
        FormalTypeParameter[] result = new FormalTypeParameter[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = FormalTypeParameter.make(args[i]);
        }
        return result;
    }

    public ClassTypeSignature getSuperclassSignature() throws IllegalArgumentException {
        return ClassTypeSignature.makeClassTypeSig(this.rawString().substring(this.endOfFormalTypeParameters(), this.endOfClassTypeSig(this.endOfFormalTypeParameters())));
    }

    private int endOfClassTypeSig(int start) throws IllegalArgumentException {
        String s = this.rawString().substring(start);
        if (s.charAt(0) != 'L') {
            throw new IllegalArgumentException("malformed ClassSignature " + this.rawString());
        }
        int i = 1;
        int depth = 0;
        while (depth > 0 || s.charAt(i) != ';') {
            if (s.charAt(i) == '<') {
                ++depth;
            }
            if (s.charAt(i) == '>') {
                --depth;
            }
            ++i;
        }
        return start + i + 1;
    }

    public ClassTypeSignature[] getSuperinterfaceSignatures() throws IllegalArgumentException {
        int start = this.endOfClassTypeSig(this.endOfFormalTypeParameters());
        ArrayList<ClassTypeSignature> result = new ArrayList<ClassTypeSignature>();
        while (start < this.rawString().length() - 1) {
            int end = this.endOfClassTypeSig(start);
            result.add(ClassTypeSignature.makeClassTypeSig(this.rawString().substring(start, end)));
            start = end;
        }
        if (result.size() == 0) {
            return null;
        }
        ClassTypeSignature[] arr = new ClassTypeSignature[result.size()];
        return result.toArray(arr);
    }

    private int endOfFormalTypeParameters() {
        if (this.rawString().charAt(0) != '<') {
            return 0;
        }
        int i = 1;
        int depth = 1;
        while (depth > 0) {
            if (this.rawString().charAt(i) == '>') {
                --depth;
            }
            if (this.rawString().charAt(i) == '<') {
                ++depth;
            }
            ++i;
        }
        return i;
    }

    public static ClassSignature getClassSignature(IClass klass) throws InvalidClassFileException {
        if (klass instanceof ShrikeClass) {
            ShrikeClass sc = (ShrikeClass)klass;
            return sc.getClassSignature();
        }
        return null;
    }
}

