/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.viz.viewer.IrViewer;
import com.ibm.wala.viz.viewer.SourceViewer;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JSplitPane;

public class IrAndSourceViewer {
    private IrViewer irViewer;
    private SourceViewer sourceViewer;
    private IR ir;

    public IrAndSourceViewer(CallGraph cg) {
    }

    public Component getComponent() {
        JSplitPane splitPane = new JSplitPane(0);
        this.irViewer = new IrViewer();
        splitPane.setLeftComponent(this.irViewer);
        this.sourceViewer = new SourceViewer();
        splitPane.setRightComponent(this.sourceViewer);
        this.irViewer.addSelectedPcListner(new IrViewer.SelectedPcListner(){

            @Override
            public void valueChanged(int pc) {
                IMethod method = IrAndSourceViewer.this.ir.getMethod();
                int sourceLineNumber = -1;
                String sourceFileName = null;
                if (pc != -1) {
                    try {
                        sourceLineNumber = method.getLineNumber(pc);
                        IClassLoader loader = method.getDeclaringClass().getClassLoader();
                        sourceFileName = loader.getSourceFileName(method, pc);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (sourceFileName != null) {
                    try {
                        URL url = new File(sourceFileName).toURI().toURL();
                        IrAndSourceViewer.this.sourceViewer.setSource(url, sourceLineNumber);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                } else {
                    IrAndSourceViewer.this.sourceViewer.removeSource();
                }
            }
        });
        return splitPane;
    }

    public void setIRAndPc(IR ir, int pc) {
        this.ir = ir;
        this.irViewer.setIRAndPc(ir, pc);
    }

    public void setIR(IR ir) {
        this.ir = ir;
        this.irViewer.setIR(ir);
    }
}

