/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.flow;

import com.ibm.appscan.sa.prefix.constants.StringConstants;
import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.appscan.sa.prefix.main.StringPrefixDomain;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.cfg.Util;
import com.ibm.wala.dataflow.IFDS.ICFGSupergraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractFlow {
    private final StringPrefixDomain domain;
    private final ICFGSupergraph supergraph;
    private final BasicBlockInContext<IExplodedBasicBlock> src;
    private final BasicBlockInContext<IExplodedBasicBlock> dest;

    public AbstractFlow(StringPrefixDomain domain, ICFGSupergraph supergraph, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        this.domain = domain;
        this.supergraph = supergraph;
        this.src = src;
        this.dest = dest;
    }

    public IntSet getTargets(int d1) {
        IntSet S = this.getTargetsImpl(d1);
        final MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        S.foreach(new IntSetAction(){

            public void act(int x) {
                if (!AbstractFlow.isStringConstant(x, AbstractFlow.this.getDomain(), (BasicBlockInContext<IExplodedBasicBlock>)AbstractFlow.this.getDest())) {
                    result.add(x);
                }
            }
        });
        return result;
    }

    private static Collection<Integer> getUses(SSAInstruction instr) {
        HashSet result = HashSetFactory.make((int)instr.getNumberOfUses());
        for (int i = 0; i < instr.getNumberOfUses(); ++i) {
            result.add(instr.getUse(i));
        }
        return result;
    }

    public SparseIntSet getTargets(int call_d, int exit_d) {
        SparseIntSet S = this.getTargetsImpl(call_d, exit_d);
        final MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        S.foreach(new IntSetAction(){

            public void act(int x) {
                if (!AbstractFlow.isStringConstant(x, AbstractFlow.this.getDomain(), (BasicBlockInContext<IExplodedBasicBlock>)AbstractFlow.this.getDest())) {
                    result.add(x);
                }
            }
        });
        return result;
    }

    public abstract IntSet getTargetsImpl(int var1);

    public SparseIntSet getTargetsImpl(int call_d, int exit_d) {
        Assertions.UNREACHABLE();
        return MutableSparseIntSet.makeEmpty();
    }

    private static boolean isStringConstant(int x, StringPrefixDomain domain, BasicBlockInContext<IExplodedBasicBlock> bb) {
        StringPrefix sp = (StringPrefix)domain.getMappedObject(x);
        for (int envPtr : sp.getEnvPtrs()) {
            if (envPtr == StringPrefix.RET || !StringConstants.isStringConstant(bb, envPtr)) continue;
            return true;
        }
        return false;
    }

    protected SparseIntSet toIntSet(StringPrefix ... strPrefs) {
        int[] indices = new int[strPrefs.length];
        for (int k = 0; k < strPrefs.length; ++k) {
            int i;
            indices[k] = i = this.domain.add(strPrefs[k]);
        }
        return this.toIntSet(indices);
    }

    protected SparseIntSet toIntSet(int ... indices) {
        MutableSparseIntSet result = MutableSparseIntSet.createMutableSparseIntSet((int)indices.length);
        for (int i : indices) {
            result.add(i);
        }
        return result;
    }

    protected Set<StringPrefix> phiOut(Set<StringPrefix> sPrefs, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        if (!((IExplodedBasicBlock)dest.getDelegate()).iteratePhis().hasNext()) {
            return sPrefs;
        }
        HashSet result = HashSetFactory.make((int)sPrefs.size());
        for (StringPrefix in : sPrefs) {
            HashSet envPtrs = HashSetFactory.make(in.getEnvPtrs());
            HashSet arrPtrs = HashSetFactory.make(in.getArrPtrs());
            Iterator phis = ((IExplodedBasicBlock)dest.getDelegate()).iteratePhis();
            while (phis.hasNext()) {
                SSAPhiInstruction phi = (SSAPhiInstruction)phis.next();
                int k = Util.whichPred((ControlFlowGraph)this.getSupergraph().getCFG(src), (IBasicBlock)src.getDelegate(), (IBasicBlock)dest.getDelegate());
                if (k == -1) continue;
                if (envPtrs.contains(phi.getUse(k))) {
                    envPtrs.add(phi.getDef());
                    continue;
                }
                if (!arrPtrs.contains(phi.getUse(k))) continue;
                arrPtrs.add(phi.getDef());
            }
            result.add(new StringPrefix(in.getPrefix(), envPtrs, arrPtrs, in.getBodyPtrs(), in.hasSuffix()));
        }
        return result;
    }

    public StringPrefixDomain getDomain() {
        return this.domain;
    }

    public ICFGSupergraph getSupergraph() {
        return this.supergraph;
    }

    public BasicBlockInContext<IExplodedBasicBlock> getSrc() {
        return this.src;
    }

    public BasicBlockInContext<IExplodedBasicBlock> getDest() {
        return this.dest;
    }
}

