/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.flow;

import com.ibm.appscan.sa.prefix.flow.AbstractFlow;
import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.appscan.sa.prefix.main.StringPrefixDomain;
import com.ibm.wala.dataflow.IFDS.ICFGSupergraph;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class UnbalancedReturnFlow
extends AbstractFlow
implements IUnaryFlowFunction {
    private final Set<SSAAbstractInvokeInstruction> calls = HashSetFactory.make();

    public UnbalancedReturnFlow(StringPrefixDomain domain, ICFGSupergraph supergraph, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        super(domain, supergraph, src, dest);
        Iterator it = supergraph.getCallSites(dest, src.getNode());
        while (it.hasNext()) {
            BasicBlockInContext callBlock = (BasicBlockInContext)it.next();
            this.calls.add((SSAAbstractInvokeInstruction)callBlock.getLastInstruction());
        }
    }

    @Override
    public IntSet getTargetsImpl(int d1) {
        StringPrefix strPref = (StringPrefix)this.getDomain().getMappedObject(d1);
        if ((strPref.getEnvPtrs().contains(StringPrefix.RET) || strPref.getArrPtrs().contains(StringPrefix.RET)) && !this.calls.isEmpty()) {
            boolean isEnvPtrs = strPref.getEnvPtrs().contains(StringPrefix.RET);
            StringPrefix[] result = new StringPrefix[this.calls.size()];
            int idx = 0;
            for (SSAAbstractInvokeInstruction invoke : this.calls) {
                result[idx++] = new StringPrefix(strPref.getPrefix(), isEnvPtrs ? Collections.singleton(invoke.getDef()) : Collections.emptySet(), isEnvPtrs ? Collections.emptySet() : Collections.singleton(invoke.getDef()), Collections.emptyMap(), strPref.hasSuffix());
            }
            return this.toIntSet(result);
        }
        return MutableSparseIntSet.makeEmpty();
    }

    public static IFlowFunction create(StringPrefixDomain domain, ICFGSupergraph supergraph, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        return new UnbalancedReturnFlow(domain, supergraph, src, dest);
    }
}

