/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.main;

import com.ibm.appscan.sa.prefix.constants.StringConstants;
import com.ibm.appscan.sa.prefix.flow.StringPrefixFlowFunctions;
import com.ibm.appscan.sa.prefix.flow.StringPrefixMergeFunction;
import com.ibm.appscan.sa.prefix.main.ISPALangServices;
import com.ibm.appscan.sa.prefix.main.ISeedsFinder;
import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.appscan.sa.prefix.main.StringPrefixDomain;
import com.ibm.wala.dataflow.IFDS.ICFGSupergraph;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.IPartiallyBalancedFlowFunctions;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationProblem;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationSolver;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StringPrefixAnalysis {
    private ICFGSupergraph supergraph;
    private final CallGraph cg;
    private final AnalysisCache analysisCache;
    private final int maxLength;
    private final int numIters;
    private final ISPALangServices langServices;
    private final ISeedsFinder seedsFinder;

    public StringPrefixAnalysis(CallGraph cg, ISPALangServices langServices, ISeedsFinder seedsFinder, int maxLength) {
        this(cg, langServices, seedsFinder, maxLength, 1);
    }

    public StringPrefixAnalysis(CallGraph cg, ISPALangServices langServices, ISeedsFinder seedsFinder, int maxLength, int numIters) {
        assert (numIters >= 1);
        this.cg = cg;
        this.analysisCache = new AnalysisCache();
        this.maxLength = maxLength;
        this.numIters = numIters;
        this.langServices = langServices;
        this.seedsFinder = seedsFinder;
    }

    public TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, StringPrefix> run() throws CancelException {
        TabulationResult result = null;
        for (int i = 0; i < this.numIters; ++i) {
            this.supergraph = ICFGSupergraph.make((CallGraph)this.cg, (AnalysisCache)this.analysisCache);
            StringPrefixProblem problem = new StringPrefixProblem();
            PartiallyBalancedTabulationSolver solver = PartiallyBalancedTabulationSolver.createPartiallyBalancedTabulationSolver((PartiallyBalancedTabulationProblem)problem, null);
            result = solver.solve();
            this.extractStringConstants((TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, StringPrefix>)result);
        }
        return result;
    }

    private void extractStringConstants(TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, StringPrefix> result) {
        Collection nodesReached = result.getSupergraphNodesReached();
        final TabulationDomain domain = result.getProblem().getDomain();
        for (BasicBlockInContext bb : nodesReached) {
            IntSet facts = result.getResult((Object)bb);
            final HashMap M = HashMapFactory.make();
            facts.foreach(new IntSetAction(){

                public void act(int x) {
                    StringPrefix p = (StringPrefix)domain.getMappedObject(x);
                    if (!p.hasSuffix()) {
                        for (int envPtr : p.getEnvPtrs()) {
                            Set S = MapUtil.findOrCreateSet((Map)M, (Object)envPtr);
                            S.add(p);
                        }
                    }
                }
            });
            for (Map.Entry e : M.entrySet()) {
                if (((Set)e.getValue()).size() != 1) continue;
                StringConstants.setStringConstant((BasicBlockInContext<IExplodedBasicBlock>)bb, (Integer)e.getKey(), ((StringPrefix)((Set)e.getValue()).iterator().next()).getPrefix());
            }
        }
    }

    private class StringPrefixProblem
    implements PartiallyBalancedTabulationProblem<BasicBlockInContext<IExplodedBasicBlock>, CGNode, StringPrefix> {
        private final StringPrefixDomain domain;
        private final IMergeFunction mergeFunc;
        private final StringPrefixFlowFunctions flow;

        private StringPrefixProblem() {
            this.domain = new StringPrefixDomain(StringPrefixAnalysis.this.maxLength);
            this.mergeFunc = new StringPrefixMergeFunction(this.domain);
            this.flow = new StringPrefixFlowFunctions(this.domain, StringPrefixAnalysis.this.supergraph, StringPrefixAnalysis.this.langServices);
        }

        public BasicBlockInContext<IExplodedBasicBlock> getFakeEntry(BasicBlockInContext<IExplodedBasicBlock> n) {
            return StringPrefixAnalysis.this.supergraph.getEntriesForProcedure(StringPrefixAnalysis.this.supergraph.getProcOf(n))[0];
        }

        public IPartiallyBalancedFlowFunctions<BasicBlockInContext<IExplodedBasicBlock>> getFunctionMap() {
            return this.flow;
        }

        public TabulationDomain<StringPrefix, BasicBlockInContext<IExplodedBasicBlock>> getDomain() {
            return this.domain;
        }

        public IMergeFunction getMergeFunction() {
            return this.mergeFunc;
        }

        public ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> getSupergraph() {
            return StringPrefixAnalysis.this.supergraph;
        }

        public Collection<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> initialSeeds() {
            Map<BasicBlockInContext<IExplodedBasicBlock>, Set<StringPrefix>> seeds = StringPrefixAnalysis.this.seedsFinder.findSeeds((CallGraph)StringPrefixAnalysis.this.supergraph.getProcedureGraph());
            HashSet result = HashSetFactory.make((int)seeds.size());
            for (Map.Entry<BasicBlockInContext<IExplodedBasicBlock>, Set<StringPrefix>> e : seeds.entrySet()) {
                CGNode n = e.getKey().getNode();
                BasicBlockInContext entry = StringPrefixAnalysis.this.supergraph.getEntriesForProcedure(n)[0];
                for (StringPrefix sp : e.getValue()) {
                    int factoid = this.domain.add(sp);
                    result.add(PathEdge.createPathEdge((Object)entry, (int)factoid, e.getKey(), (int)factoid));
                }
            }
            return result;
        }
    }
}

