/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.clazz.info;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.assessment.model.Taint;
import java.util.HashSet;

public class FieldTracker {
    private HashSet<String> m_in_methods = new HashSet();
    private HashSet<String> m_out_methods = new HashSet();
    private String m_field_name;

    public FieldTracker(String name) {
        this.m_field_name = name;
    }

    public String getFieldName() {
        return this.m_field_name;
    }

    public HashSet<String> getInMethods() {
        return this.m_in_methods;
    }

    public HashSet<String> getOutMethods() {
        return this.m_out_methods;
    }

    public void addInMethod(String method_signature) {
        this.m_in_methods.add(method_signature);
    }

    public void addOutMethod(String method_signature) {
        this.m_out_methods.add(method_signature);
    }

    public boolean allowsForDataFlow(Finding finding) {
        boolean has_proper_out_method = false;
        String arg_name = null;
        for (Taint t : finding.getTrace().getTaintList()) {
            if (this.m_in_methods.contains(t.getSite().getSignature()) && this.m_field_name.equals(t.getName())) {
                arg_name = t.getName();
            }
            if (arg_name == null || !this.m_out_methods.contains(t.getSite().getSignature())) continue;
            has_proper_out_method = true;
        }
        if (arg_name != null) {
            return has_proper_out_method;
        }
        return true;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.m_field_name);
        ret.append(System.lineSeparator());
        ret.append("In:");
        ret.append(System.lineSeparator());
        for (String in : this.m_in_methods) {
            ret.append("\t");
            ret.append(in);
            ret.append(System.lineSeparator());
        }
        ret.append("Out:");
        ret.append(System.lineSeparator());
        for (String out : this.m_out_methods) {
            ret.append("\t");
            ret.append(out);
            ret.append(System.lineSeparator());
        }
        return ret.toString();
    }
}

