/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.handlers.spring3.Util;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.EnclosingFormal;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;

public class SpringValidator {
    private SpringValidatorType type;
    private String validatorClassName;
    private String validatorMethodName;
    private IClass clazzToBeValidate;
    private IField fieldToBeValidate;
    private FilePositionInfo filePositioninfo;
    private HighLevelSyntheticMethod fieldValidatorSynMethod = null;
    private HighLevelSyntheticMethod classValidatorSynMethod = null;

    public SpringValidator(SpringValidatorType type, String validatorParam, IField fieldToBeValidate, IClass clazzToBeValidate) {
        this.type = type;
        this.clazzToBeValidate = clazzToBeValidate;
        this.fieldToBeValidate = fieldToBeValidate;
        this.filePositioninfo = FilePositionInfo.make((String)fieldToBeValidate.getDeclaringClass().getSourceFileName(), (int)1, (int)1);
    }

    public FilePositionInfo getFilePositioninfo() {
        return this.filePositioninfo;
    }

    public void setFilePositioninfo(FilePositionInfo filePositioninfo) {
        this.filePositioninfo = filePositioninfo;
    }

    public IClass getClazzToBeValidate() {
        return this.clazzToBeValidate;
    }

    public IField getFieldToBeValidate() {
        return this.fieldToBeValidate;
    }

    public void setValidatorClassName(String className) {
        this.validatorClassName = className;
    }

    private String getVdbSignatureForFieldLevelValidator() {
        String clazzTypeVDBSig = Util.getVDBSignature(this.clazzToBeValidate);
        System.out.println(clazzTypeVDBSig);
        String vdbSig = "AppScan.Synthetic.Validator.Spring3." + this.fieldToBeValidate.getName() + "(" + clazzTypeVDBSig + "):" + clazzTypeVDBSig;
        return vdbSig;
    }

    private String getVdbSignatureForClassLevelValidator() {
        String clazzTypeVDBSig = Util.getVDBSignature(this.clazzToBeValidate);
        System.out.println(clazzTypeVDBSig);
        String vdbSig = "AppScan.Synthetic.Validator.Spring3." + Util.getVDBSignature(this.clazzToBeValidate).replace(".", "_") + "(" + clazzTypeVDBSig + "):" + clazzTypeVDBSig;
        System.out.println("vdbSig = " + vdbSig);
        return vdbSig;
    }

    public HighLevelSyntheticMethod getFieldLevelValidateSynMethod() {
        if (this.fieldValidatorSynMethod == null) {
            this.fieldValidatorSynMethod = this.createValidatorSyntheticMethod();
        }
        return this.fieldValidatorSynMethod;
    }

    public HighLevelSyntheticMethod getClassLevelValidateSynMethod() {
        if (this.classValidatorSynMethod == null) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{this.getVdbSignatureForClassLevelValidator()}));
            this.classValidatorSynMethod = HighLevelSyntheticMethod.make((String)this.getVdbSignatureForClassLevelValidator());
            this.classValidatorSynMethod.setReturnedValue((Param)EnclosingFormal.FIRST);
        }
        return this.classValidatorSynMethod;
    }

    private HighLevelSyntheticMethod createValidatorSyntheticMethod() {
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{this.getVdbSignatureForFieldLevelValidator()}));
        HighLevelSyntheticMethod validatorSynMethod = HighLevelSyntheticMethod.make((String)this.getVdbSignatureForFieldLevelValidator());
        switch (this.type) {
            case VALIDATOR_MIN: 
            case VALIDATOR_MAX: 
            case VALIDATOR_SIZE: 
            case VALIDATOR_NOTNULL: 
            case VALIDATOR_NOTEMPTY: 
            case VALIDATOR_NUMBERFORMAT: 
            case VALIDATOR_RANGE: 
            case VALIDATOR_VALID: {
                validatorSynMethod.setReturnedValue((Param)EnclosingFormal.FIRST);
                break;
            }
            default: {
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.validator", (Object[])new Object[]{" fieldToBeValidate = " + this.fieldToBeValidate.getName().toString() + ") in file " + this.filePositioninfo.toString()}));
            }
        }
        return validatorSynMethod;
    }

    public static enum SpringValidatorType {
        VALIDATOR_MIN,
        VALIDATOR_MAX,
        VALIDATOR_SIZE,
        VALIDATOR_NOTNULL,
        VALIDATOR_NOTEMPTY,
        VALIDATOR_NUMBERFORMAT,
        VALIDATOR_RANGE,
        VALIDATOR_VALID;

    }
}

