/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;

public abstract class ConstantInstruction
extends Instruction {
    public ConstantInstruction(short opcode) {
        super(opcode);
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    int getCPIndex() {
        return 0;
    }

    public abstract Object getValue();

    public abstract String getType();

    public static ConstantInstruction make(String type, Object constant) throws IllegalArgumentException {
        if (type == null && constant != null) {
            throw new IllegalArgumentException("(type == null) and (constant != null)");
        }
        if (constant == null) {
            return ConstNull.makeInternal();
        }
        if (type.equals("Ljava/lang/String;")) {
            return ConstantInstruction.makeString((String)constant);
        }
        if (type.equals("Ljava/lang/Class;")) {
            return ConstantInstruction.makeClass((String)constant);
        }
        try {
            switch (Util.getTypeIndex(type)) {
                case 0: {
                    return ConstantInstruction.make(((Number)constant).intValue());
                }
                case 1: {
                    return ConstantInstruction.make(((Number)constant).longValue());
                }
                case 2: {
                    return ConstantInstruction.make(((Number)constant).floatValue());
                }
                case 3: {
                    return ConstantInstruction.make(((Number)constant).doubleValue());
                }
            }
            throw new IllegalArgumentException("Invalid type for constant: " + type);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ConstantInstruction make(int i) {
        return ConstInt.makeInternal(i);
    }

    public static ConstantInstruction make(long l) {
        return ConstLong.makeInternal(l);
    }

    public static ConstantInstruction make(float f) {
        return ConstFloat.makeInternal(f);
    }

    public static ConstantInstruction make(double d) {
        return ConstDouble.makeInternal(d);
    }

    public static ConstantInstruction makeString(String s) {
        return s == null ? ConstNull.makeInternal() : ConstString.makeInternal(s);
    }

    public static ConstantInstruction makeClass(String s) {
        return ConstClass.makeInternal(s);
    }

    public static ConstantInstruction make(ConstantPoolReader cp, int index) {
        switch (cp.getConstantPoolItemType(index)) {
            case 3: {
                return new LazyInt(19, cp, index);
            }
            case 5: {
                return new LazyLong(20, cp, index);
            }
            case 4: {
                return new LazyFloat(19, cp, index);
            }
            case 6: {
                return new LazyDouble(20, cp, index);
            }
            case 8: {
                return new LazyString(19, cp, index);
            }
            case 7: {
                return new LazyClass(19, cp, index);
            }
            case 15: {
                return new LazyMethodHandle(19, cp, index);
            }
            case 16: {
                return new LazyMethodType(19, cp, index);
            }
            case 18: {
                return new LazyInvokeDynamic(19, cp, index);
            }
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (o instanceof ConstantInstruction) {
            ConstantInstruction i = (ConstantInstruction)o;
            if (!i.getType().equals(this.getType())) {
                return false;
            }
            if (i.getValue() == null) {
                return this.getValue() == null;
            }
            if (this.getValue() == null) {
                return false;
            }
            return i.getValue().equals(this.getValue());
        }
        return false;
    }

    @Override
    public final String getPushedType(String[] types) {
        return this.getType();
    }

    @Override
    public final byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public final int hashCode() {
        int v = this.getValue() == null ? 0 : this.getValue().hashCode();
        return this.getType().hashCode() + 14411 * v;
    }

    @Override
    public final void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitConstant(this);
    }

    private static String quote(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            StringBuffer buf = new StringBuffer("\"");
            int len = s.length();
            block5: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        buf.append('\\');
                        buf.append(ch);
                        continue block5;
                    }
                    case '\n': {
                        buf.append("\\\n");
                        continue block5;
                    }
                    case '\t': {
                        buf.append("\\\t");
                        continue block5;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
            buf.append("\"");
            return buf.toString();
        }
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    @Override
    public final String toString() {
        return "Constant(" + this.getType() + "," + ConstantInstruction.quote(this.getValue()) + ")";
    }

    @Override
    public boolean isPEI() {
        return false;
    }

    static class LazyInvokeDynamic
    extends ConstMethodHandle {
        private final ConstantPoolReader cp;
        private final int index;

        LazyInvokeDynamic(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null);
            this.cp = cp;
            this.index = index;
        }

        @Override
        public Object getValue() {
            if (this.value == null) {
                BootstrapMethodsReader.BootstrapMethod bootstrap = this.cp.getConstantPoolDynamicBootstrap(this.index);
                String name = this.cp.getConstantPoolDynamicName(this.index);
                String type = this.cp.getConstantPoolDynamicType(this.index);
                this.value = new InvokeDynamicToken(bootstrap, name, type);
            }
            return this.value;
        }

        @Override
        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        @Override
        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstInvokeDynamic
    extends ConstantInstruction {
        protected Object value;

        public ConstInvokeDynamic(short opcode, Object value) {
            super(opcode);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getType() {
            return null;
        }
    }

    static class LazyMethodHandle
    extends ConstMethodHandle {
        private final ConstantPoolReader cp;
        private final int index;

        LazyMethodHandle(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null);
            this.cp = cp;
            this.index = index;
        }

        @Override
        public Object getValue() {
            if (this.value == null) {
                String className = this.cp.getConstantPoolHandleClassType(this.getCPIndex());
                String eltName = this.cp.getConstantPoolHandleName(this.getCPIndex());
                String eltDesc = this.cp.getConstantPoolHandleType(this.getCPIndex());
                byte kind = this.cp.getConstantPoolHandleKind(this.getCPIndex());
                this.value = new ConstantPoolParser.ReferenceToken(kind, className, eltName, eltDesc);
            }
            return this.value;
        }

        @Override
        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        @Override
        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstMethodHandle
    extends ConstantInstruction {
        protected Object value;

        public ConstMethodHandle(short opcode, Object value) {
            super(opcode);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getType() {
            return "Ljava/lang/invoke/MethodHandle;";
        }
    }

    static class LazyMethodType
    extends ConstMethodType {
        private final ConstantPoolReader cp;
        private final int index;

        LazyMethodType(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null);
            this.cp = cp;
            this.index = index;
        }

        @Override
        public Object getValue() {
            if (this.descriptor == null) {
                this.descriptor = this.cp.getConstantPoolMethodType(this.index);
            }
            return this.descriptor;
        }

        @Override
        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        @Override
        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstMethodType
    extends ConstantInstruction {
        protected String descriptor;

        ConstMethodType(short opcode, String descriptor) {
            super(opcode);
            this.descriptor = descriptor;
        }

        @Override
        public Object getValue() {
            return this.descriptor;
        }

        @Override
        public String getType() {
            return "Ljava/lang/invoke/MethodType;";
        }
    }

    static final class LazyClass
    extends ConstClass {
        private final ConstantPoolReader cp;
        private final int index;

        protected LazyClass(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null);
            this.cp = cp;
            this.index = index;
        }

        @Override
        public Object getValue() {
            if (this.typeName == null) {
                this.typeName = this.cp.getConstantPoolClassType(this.index);
            }
            return new ClassToken(this.typeName);
        }

        @Override
        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        @Override
        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstClass
    extends ConstantInstruction {
        protected String typeName;

        protected ConstClass(short opcode, String typeName) {
            super(opcode);
            this.typeName = typeName;
        }

        static ConstClass makeInternal(String v) {
            return new ConstClass(19, v);
        }

        @Override
        public Object getValue() {
            return new ClassToken(this.typeName);
        }

        @Override
        public final String getType() {
            return "Ljava/lang/Class;";
        }

        @Override
        public boolean isPEI() {
            return true;
        }
    }

    static final class LazyString
    extends ConstString {
        private final ConstantPoolReader cp;
        private final int index;

        protected LazyString(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null);
            this.cp = cp;
            this.index = index;
        }

        @Override
        public Object getValue() {
            if (this.value == null) {
                this.value = this.cp.getConstantPoolString(this.index);
            }
            return this.value;
        }

        @Override
        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        @Override
        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstString
    extends ConstantInstruction {
        protected String value;

        protected ConstString(short opcode, String value) {
            super(opcode);
            this.value = value;
        }

        static ConstString makeInternal(String v) {
            return new ConstString(19, v);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public final String getType() {
            return "Ljava/lang/String;";
        }
    }

    static final class LazyDouble
    extends ConstDouble {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyDouble(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, 0.0);
            this.cp = cp;
            this.index = index;
            this.isSet = false;
        }

        @Override
        public double getDoubleValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolDouble(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        @Override
        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        @Override
        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstDouble
    extends ConstantInstruction {
        protected double value;
        private static final ConstDouble[] preallocated = ConstDouble.preallocate();

        protected ConstDouble(short opcode, double value) {
            super(opcode);
            this.value = value;
        }

        private static ConstDouble[] preallocate() {
            ConstDouble[] r = new ConstDouble[]{new ConstDouble(14, 0.0), new ConstDouble(15, 1.0)};
            return r;
        }

        static ConstDouble makeInternal(double v) {
            if (v == 0.0 || v == 1.0) {
                return preallocated[(int)v];
            }
            return new ConstDouble(20, v);
        }

        @Override
        public final Object getValue() {
            return new Double(this.getDoubleValue());
        }

        @Override
        public final String getType() {
            return "D";
        }

        public double getDoubleValue() {
            return this.value;
        }
    }

    static final class LazyFloat
    extends ConstFloat {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyFloat(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, 0.0f);
            this.cp = cp;
            this.index = index;
            this.isSet = false;
        }

        @Override
        public float getFloatValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolFloat(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        @Override
        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        @Override
        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstFloat
    extends ConstantInstruction {
        protected float value;
        private static final ConstFloat[] preallocated = ConstFloat.preallocate();

        protected ConstFloat(short opcode, float value) {
            super(opcode);
            this.value = value;
        }

        private static ConstFloat[] preallocate() {
            ConstFloat[] r = new ConstFloat[]{new ConstFloat(11, 0.0f), new ConstFloat(12, 1.0f), new ConstFloat(13, 2.0f)};
            return r;
        }

        static ConstFloat makeInternal(float v) {
            if ((double)v == 0.0 || (double)v == 1.0 || (double)v == 2.0) {
                return preallocated[(int)v];
            }
            return new ConstFloat(19, v);
        }

        @Override
        public final Object getValue() {
            return new Float(this.getFloatValue());
        }

        @Override
        public final String getType() {
            return "F";
        }

        public float getFloatValue() {
            return this.value;
        }
    }

    static final class LazyLong
    extends ConstLong {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyLong(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, 0L);
            this.cp = cp;
            this.index = index;
            this.isSet = false;
        }

        @Override
        public long getLongValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolLong(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        @Override
        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        @Override
        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstLong
    extends ConstantInstruction {
        protected long value;
        private static final ConstLong[] preallocated = ConstLong.preallocate();

        protected ConstLong(short opcode, long value) {
            super(opcode);
            this.value = value;
        }

        private static ConstLong[] preallocate() {
            ConstLong[] r = new ConstLong[]{new ConstLong(9, 0L), new ConstLong(10, 1L)};
            return r;
        }

        static ConstLong makeInternal(long v) {
            if (v == 0L || v == 1L) {
                return preallocated[(int)v];
            }
            return new ConstLong(20, v);
        }

        @Override
        public final Object getValue() {
            return this.getLongValue();
        }

        @Override
        public final String getType() {
            return "J";
        }

        public long getLongValue() {
            return this.value;
        }
    }

    static final class LazyInt
    extends ConstInt {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyInt(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, 0);
            this.cp = cp;
            this.index = index;
            this.isSet = false;
        }

        @Override
        public int getIntValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolInteger(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        @Override
        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        @Override
        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstInt
    extends ConstantInstruction {
        protected int value;
        private static final ConstInt[] preallocated = ConstInt.preallocate();

        protected ConstInt(short opcode, int value) {
            super(opcode);
            this.value = value;
        }

        private static ConstInt[] preallocate() {
            int i;
            ConstInt[] r = new ConstInt[256];
            for (i = 0; i < r.length; ++i) {
                r[i] = new ConstInt(16, i - 128);
            }
            for (i = -1; i <= 5; ++i) {
                r[i + 128] = new ConstInt((short)(i - -1 + 2), i);
            }
            return r;
        }

        static ConstInt makeInternal(int i) {
            if ((byte)i == i) {
                return preallocated[i + 128];
            }
            if ((short)i == i) {
                return new ConstInt(17, i);
            }
            return new ConstInt(19, i);
        }

        @Override
        public final Object getValue() {
            return this.getIntValue();
        }

        @Override
        public final String getType() {
            return "I";
        }

        public int getIntValue() {
            return this.value;
        }
    }

    static final class ConstNull
    extends ConstantInstruction {
        private static final ConstNull preallocated = new ConstNull();

        protected ConstNull() {
            super((short)1);
        }

        static ConstNull makeInternal() {
            return preallocated;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public String getType() {
            return "L;";
        }
    }

    public static class ClassToken {
        private final String typeName;

        ClassToken(String typeName) {
            this.typeName = typeName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassToken other = (ClassToken)obj;
            return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    public static class InvokeDynamicToken {
        private final BootstrapMethodsReader.BootstrapMethod bootstrapMethod;
        private final String name;
        private final String type;

        public InvokeDynamicToken(BootstrapMethodsReader.BootstrapMethod bootstrapMethod, String name, String type) {
            this.bootstrapMethod = bootstrapMethod;
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bootstrapMethod == null ? 0 : this.bootstrapMethod.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvokeDynamicToken other = (InvokeDynamicToken)obj;
            if (this.bootstrapMethod == null ? other.bootstrapMethod != null : !this.bootstrapMethod.equals(other.bootstrapMethod)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

