/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner;

import com.hcl.appscan.source.scanner.ActionRunner;
import com.hcl.appscan.source.scanner.IAction;
import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.job.AnalysisAction;
import com.hcl.appscan.source.scanner.job.ScanJob;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerProgress;
import com.hcl.appscan.source.scanner.results.IResult;
import com.ibm.appscan.common.IProgress;
import java.io.File;
import java.util.List;
import java.util.Map;

public class SourceCodeScanner
implements IAction {
    private ScanJob m_job;
    private File m_resultsDir;
    private IProgress m_progress;
    private Map<String, String> m_sourceFileMap;
    private String m_language;

    public SourceCodeScanner(String language, File zipFile, File resultsDir, File logDir, IProgress progress, Map<String, String> sourceFileMap) {
        String asocScanId = System.getProperty("APPSCAN_AGENT_JOBID");
        SourceCodeScannerProgress scannerProgress = new SourceCodeScannerProgress(progress, logDir);
        this.m_progress = scannerProgress;
        this.m_job = new ScanJob(zipFile, asocScanId, language, scannerProgress, null);
        this.m_resultsDir = resultsDir;
        this.m_sourceFileMap = sourceFileMap;
        this.m_language = language;
    }

    public void execute() throws SourceCodeScannerException {
        ActionRunner.executeAction(this, this.m_progress, 1);
    }

    @Override
    public void run() throws SourceCodeScannerException {
        this.executeJob();
        IResult result = this.getResults();
        this.processResults(result);
    }

    public List<String> getDeferredFiles() throws SourceCodeScannerException {
        return this.m_job.getDeferredFiles();
    }

    private void executeJob() throws SourceCodeScannerException {
        ActionRunner.executeAction(new AnalysisAction(this.m_job, this.m_progress), this.m_progress);
    }

    private IResult getResults() throws SourceCodeScannerException {
        return this.m_job.getResult();
    }

    private void processResults(IResult result) throws SourceCodeScannerException {
        result.getConvertedResult(this.m_resultsDir, this.m_sourceFileMap, this.m_language);
    }

    @Override
    public String getDescription() {
        return Messages.getMessage("action.scan", new Object[0]);
    }
}

