/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.irx.slice.AzureIrxMinorCache;
import com.hcl.irx.slice.Bucket;
import com.hcl.irx.slice.FileIrxMinorCache;
import com.hcl.irx.slice.IrxCacheConstants;
import com.hcl.irx.slice.IrxMinorCache;
import com.hcl.irx.slice.Messages;
import com.hcl.irx.slice.Nexus3IrxMinorCache;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.json.JSONException;

public class IrxMinorCacheManagement
implements IrxCacheConstants {
    private static IrxMinorCache s_cache = null;

    public static boolean copyIrxMinorToSliceDir(Bucket bucket, File settings_dir, File slice) throws NoSuchAlgorithmException, IOException {
        return IrxMinorCacheManagement.getIrxMinorCache().copyCacheEntryToFile(bucket, settings_dir, slice);
    }

    public static void insertIrxMinorToCache(Bucket bucket, File settings_dir, File source) throws NoSuchAlgorithmException, IOException {
        IrxMinorCacheManagement.getIrxMinorCache().insertCacheEntry(bucket, settings_dir, source);
    }

    public static boolean isBucketInCache(Bucket bucket) throws NoSuchAlgorithmException, AppScanException, IOException {
        return IrxMinorCacheManagement.getIrxMinorCache().objectInCache(bucket, bucket.getBucketDir());
    }

    public static String getCacheKeyForBucket(Bucket b) throws NoSuchAlgorithmException, IOException {
        return IrxMinorCacheManagement.getIrxMinorCache().generateSha256Key(b, b.getBucketDir());
    }

    public static boolean cleanupIfNeeded() {
        return IrxMinorCacheManagement.getIrxMinorCache().checkCacheForCleanup();
    }

    public static HashMap<String, HashSet<String>> getPreviousBuckets() throws IOException, JSONException {
        return IrxMinorCacheManagement.getIrxMinorCache().getPreviousBuckets(false);
    }

    protected static void updatePreviousBuckets(HashMap<String, HashSet<String>> new_buckets) throws JSONException, IOException {
        IrxMinorCacheManagement.getIrxMinorCache().updatePreviousBuckets(new_buckets);
    }

    public static String getCurrentUsage() {
        StringBuilder ret = new StringBuilder();
        IrxMinorCache cache = IrxMinorCacheManagement.getIrxMinorCache();
        ret.append(System.lineSeparator());
        ret.append(Messages.getMessage("cache.usage.title", cache.getClass().getName()));
        ret.append(System.lineSeparator());
        ret.append(Messages.getMessage("cache.hash.version", cache.getCacheVersionToUse()));
        ret.append(System.lineSeparator());
        if (cache instanceof FileIrxMinorCache) {
            ret.append(Messages.getMessage("cache.home", ((FileIrxMinorCache)cache).getIrxMinorCacheHome()));
            ret.append(System.lineSeparator());
        }
        if (cache instanceof Nexus3IrxMinorCache) {
            ret.append(Messages.getMessage("cache.nexus.url", ((Nexus3IrxMinorCache)cache).getNexusUrl()));
            ret.append(System.lineSeparator());
            ret.append(Messages.getMessage("cache.nexus.repo", ((Nexus3IrxMinorCache)cache).getRepository()));
            ret.append(System.lineSeparator());
        }
        ret.append(Messages.getMessage("cache.storage.space", FileUtil.getByteStringFromFileSize((long)cache.getUsedSpaceInCache()), FileUtil.getByteStringFromFileSize((long)cache.getMaxCacheSpaceAllowed_()), (double)cache.getUsedSpaceInCache() / cache.getMaxCacheSpaceAllowed() * 100.0));
        ret.append(System.lineSeparator());
        ret.append(Messages.getMessage("cache.entry.count", cache.getCacheEntryCount(), cache.getMaxEntriesAllowed_(), (double)cache.getCacheEntryCount() / (double)cache.getMaxEntriesAllowed_() * 100.0));
        ret.append(System.lineSeparator());
        return ret.toString();
    }

    private static synchronized IrxMinorCache getIrxMinorCache() {
        if (s_cache == null) {
            s_cache = SystemUtil.isPropertySet((String)"IRX_CACHE_AZURE_URL") ? new AzureIrxMinorCache(System.getProperty("IRX_CACHE_AZURE_URL")) : (SystemUtil.isPropertySet((String)"IRX_MINOR_CACHE_NEXUS_URL") ? new Nexus3IrxMinorCache() : new FileIrxMinorCache());
        }
        return s_cache;
    }
}

