/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.irx.slice.IrxMinorCache;
import com.hcl.irx.slice.Messages;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class Nexus3IrxMinorCache
extends IrxMinorCache {
    private static final int BUFFER_SIZE = 1024;
    private boolean m_isHttps = false;
    private ConcurrentHashMap<String, String> m_bucketKeyId = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> m_bucketKeyDownloadLink = new ConcurrentHashMap();
    private JSONArray m_irx_minor_files;
    private String m_username;
    private String m_password;
    private String m_nexus_url;
    private String m_repo;

    @Override
    protected void deleteAllFilesInCache() {
        try {
            JSONArray test = this.getIrxMinorFiles();
            for (int i = 0; i < test.length(); ++i) {
                this.deleteFile(test.getJSONObject(i).getString("id"));
            }
            this.m_bucketKeyId.clear();
            this.m_bucketKeyDownloadLink.clear();
            test = null;
        }
        catch (JSONException e) {
            CommonCore.getLogManager().log((Exception)((Object)e));
        }
    }

    private String getUsernameAndPassword() {
        if (this.m_username == null || this.m_password == null) {
            this.m_username = System.getProperty("IRX_MINOR_CACHE_NEXUS_USERNAME");
            this.m_password = System.getProperty("IRX_MINOR_CACHE_NEXUS_PASSWORD");
        }
        return this.m_username + ":" + this.m_password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNexusUrl() {
        if (this.m_nexus_url != null) return this.m_nexus_url;
        this.m_nexus_url = System.getProperty("IRX_MINOR_CACHE_NEXUS_URL");
        if (this.isHttpsConnection()) {
            URL url = null;
            HttpURLConnection connection = null;
            try {
                url = new URL(this.m_nexus_url + "/service/rest/v1/components?repository=" + this.getRepository());
                if (url.getProtocol().equals("https")) {
                    this.m_isHttps = true;
                }
                connection = (HttpsURLConnection)url.openConnection();
                connection.setRequestProperty("X-Requested-With", "Curl");
                connection.setRequestMethod("GET");
                String basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
                connection.setRequestProperty("Authorization", basicAuth);
                if (connection.getResponseCode() == 200) return this.m_nexus_url;
                CommonCore.getLogManager().log(new Message((Throwable)new AppScanException(Messages.getMessage("http.response.code", connection.getResponseCode()))));
                System.exit(-1);
                return this.m_nexus_url;
            }
            catch (MalformedURLException e) {
                CommonCore.getLogManager().log((Exception)e);
                return this.m_nexus_url;
            }
            catch (IOException e) {
                CommonCore.getLogManager().log((Exception)e);
                return this.m_nexus_url;
            }
            finally {
                connection.disconnect();
            }
        }
        URL url = null;
        HttpURLConnection connection = null;
        try {
            url = new URL(this.m_nexus_url + "/service/rest/v1/components?repository=" + this.getRepository());
            if (url.getProtocol().equals("https")) {
                this.m_isHttps = true;
            }
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("X-Requested-With", "Curl");
            connection.setRequestMethod("GET");
            String basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
            connection.setRequestProperty("Authorization", basicAuth);
            if (connection.getResponseCode() == 200) return this.m_nexus_url;
            CommonCore.getLogManager().log(new Message((Throwable)new AppScanException(Messages.getMessage("http.response.code", connection.getResponseCode()))));
            System.exit(-1);
            return this.m_nexus_url;
        }
        catch (MalformedURLException e) {
            CommonCore.getLogManager().log((Exception)e);
            return this.m_nexus_url;
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
            return this.m_nexus_url;
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray getIrxMinorFiles() {
        if (this.m_irx_minor_files == null) {
            URL url = null;
            if (this.isHttpsConnection()) {
                HttpURLConnection connection = null;
                try {
                    url = new URL(this.getNexusUrl() + "/service/rest/v1/components?repository=" + this.getRepository());
                    connection = (HttpsURLConnection)url.openConnection();
                    connection.setRequestProperty("X-Requested-With", "Curl");
                    connection.setRequestMethod("GET");
                    String basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
                    connection.setRequestProperty("Authorization", basicAuth);
                    connection.getResponseCode();
                    InputStream in = connection.getInputStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    StringBuilder sb = new StringBuilder();
                    String inputStr = null;
                    while ((inputStr = br.readLine()) != null) {
                        sb.append(inputStr);
                    }
                    JSONObject json = new JSONObject(sb.toString());
                    this.m_irx_minor_files = json.getJSONArray("items");
                    for (int i = 0; i < this.m_irx_minor_files.length(); ++i) {
                        String bucketKey = this.m_irx_minor_files.getJSONObject(i).getString("name").substring(19);
                        String bucketKeyId = this.m_irx_minor_files.getJSONObject(i).getString("id");
                        String bucketDownloadLink = this.m_irx_minor_files.getJSONObject(i).getJSONArray("assets").getJSONObject(0).get("downloadUrl").toString();
                        this.m_bucketKeyId.put(bucketKey, bucketKeyId);
                        this.m_bucketKeyDownloadLink.put(bucketKey, bucketDownloadLink);
                    }
                }
                catch (MalformedURLException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
                catch (ProtocolException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
                catch (IOException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
                catch (JSONException e) {
                    CommonCore.getLogManager().log((Exception)((Object)e));
                }
                finally {
                    connection.disconnect();
                }
            } else {
                HttpURLConnection connection = null;
                try {
                    url = new URL(this.getNexusUrl() + "/service/rest/v1/components?repository=" + this.getRepository());
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestProperty("X-Requested-With", "Curl");
                    connection.setRequestMethod("GET");
                    String basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
                    connection.setRequestProperty("Authorization", basicAuth);
                    connection.getResponseCode();
                    InputStream in = connection.getInputStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    StringBuilder sb = new StringBuilder();
                    String inputStr = null;
                    while ((inputStr = br.readLine()) != null) {
                        sb.append(inputStr);
                    }
                    JSONObject json = new JSONObject(sb.toString());
                    this.m_irx_minor_files = json.getJSONArray("items");
                    for (int i = 0; i < this.m_irx_minor_files.length(); ++i) {
                        String bucketKey = this.m_irx_minor_files.getJSONObject(i).getString("name").substring(19);
                        String bucketKeyId = this.m_irx_minor_files.getJSONObject(i).getString("id");
                        String bucketDownloadLink = this.m_irx_minor_files.getJSONObject(i).getJSONArray("assets").getJSONObject(0).get("downloadUrl").toString();
                        this.m_bucketKeyId.put(bucketKey, bucketKeyId);
                        this.m_bucketKeyDownloadLink.put(bucketKey, bucketDownloadLink);
                    }
                }
                catch (MalformedURLException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
                catch (ProtocolException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
                catch (IOException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
                catch (JSONException e) {
                    CommonCore.getLogManager().log((Exception)((Object)e));
                }
                finally {
                    connection.disconnect();
                }
            }
        }
        return this.m_irx_minor_files;
    }

    private String getDownloadLink(String bucketKey) {
        if (this.getIrxMinorFiles() != null) {
            return this.m_bucketKeyDownloadLink.get(bucketKey);
        }
        return null;
    }

    private String getBucketKeyId(String bucketKey) {
        if (this.getIrxMinorFiles() != null) {
            return this.m_bucketKeyId.get(bucketKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(String bucketKeyId) {
        URL url = null;
        if (this.isHttpsConnection()) {
            HttpURLConnection connection = null;
            try {
                url = new URL(this.getNexusUrl() + "/service/rest/v1/components/" + bucketKeyId);
                connection = (HttpsURLConnection)url.openConnection();
                connection.setRequestProperty("X-Requested-With", "Curl");
                connection.setRequestMethod("DELETE");
                String basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
                connection.setRequestProperty("Authorization", basicAuth);
                connection.getResponseCode();
            }
            catch (MalformedURLException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
            catch (IOException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
            finally {
                connection.disconnect();
            }
        } else {
            HttpURLConnection connection = null;
            try {
                url = new URL(this.getNexusUrl() + "/service/rest/v1/components/" + bucketKeyId);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("X-Requested-With", "Curl");
                connection.setRequestMethod("DELETE");
                String basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
                connection.setRequestProperty("Authorization", basicAuth);
                connection.getResponseCode();
            }
            catch (MalformedURLException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
            catch (IOException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
            finally {
                connection.disconnect();
            }
        }
    }

    protected String getRepository() {
        if (this.m_repo == null) {
            this.m_repo = SystemUtil.isPropertySet((String)"IRX_MINOR_CACHE_NEXUS_REPO") ? System.getProperty("IRX_MINOR_CACHE_NEXUS_REPO") : "HCLStaticAnalyzer";
        }
        return this.m_repo;
    }

    private boolean isHttpsConnection() {
        return this.m_isHttps;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean insertCacheEntry(String key, File source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected InputStream getCacheEntry(String key) throws AppScanException {
        block10: {
            String irxMinorDownloadLink = null;
            if (this.getDownloadLink(key) == null) {
                return null;
            }
            irxMinorDownloadLink = this.getDownloadLink(key);
            try {
                URL url = new URL(irxMinorDownloadLink);
                if (url.getProtocol().equals("https")) {
                    HttpsURLConnection connection = null;
                    try {
                        connection = (HttpsURLConnection)url.openConnection();
                        connection.setRequestProperty("X-Requested-With", "Curl");
                        connection.setRequestMethod("GET");
                        String basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
                        connection.setRequestProperty("Authorization", basicAuth);
                        if (connection.getResponseCode() == 200) {
                            return connection.getInputStream();
                        }
                        break block10;
                    }
                    catch (IOException e) {
                        CommonCore.getLogManager().log((Exception)e);
                    }
                    break block10;
                }
                HttpURLConnection connection = null;
                try {
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestProperty("X-Requested-With", "Curl");
                    connection.setRequestMethod("GET");
                    String basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
                    connection.setRequestProperty("Authorization", basicAuth);
                    if (connection.getResponseCode() == 200) {
                        return connection.getInputStream();
                    }
                }
                catch (IOException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
            }
            catch (MalformedURLException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
        }
        return null;
    }

    @Override
    protected long getMaxEntriesAllowed_() {
        return 10000L;
    }

    @Override
    protected long getCacheEntryCount() {
        return this.m_bucketKeyId.size();
    }

    @Override
    protected void reduceCacheEntry() {
        if (this.getIrxMinorFiles() != null) {
            Object[] IrxMinorKeySet = ((ConcurrentHashMap.CollectionView)((Object)this.m_bucketKeyId.keySet())).toArray();
            int index = new Random().nextInt(IrxMinorKeySet.length);
            Object key = IrxMinorKeySet[index];
            this.deleteFile(this.getBucketKeyId(key.toString()));
            this.m_bucketKeyId.remove(key.toString());
            this.m_bucketKeyDownloadLink.remove(key.toString());
        }
    }

    @Override
    protected long getUsedSpaceInCache() {
        long usedSpace = 0L;
        String irxMinorDownloadLink = null;
        if (this.getIrxMinorFiles() != null) {
            for (String key : this.m_bucketKeyDownloadLink.keySet()) {
                irxMinorDownloadLink = this.getDownloadLink(key);
                try {
                    String basicAuth;
                    HttpURLConnection connection;
                    URL url = new URL(irxMinorDownloadLink);
                    if (url.getProtocol().equals("https")) {
                        connection = null;
                        try {
                            connection = (HttpsURLConnection)url.openConnection();
                            connection.setRequestProperty("X-Requested-With", "Curl");
                            connection.setRequestMethod("GET");
                            basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
                            connection.setRequestProperty("Authorization", basicAuth);
                            if (connection.getResponseCode() != 200) continue;
                            usedSpace += (long)connection.getInputStream().available();
                        }
                        catch (IOException e) {
                            CommonCore.getLogManager().log((Exception)e);
                        }
                        continue;
                    }
                    connection = null;
                    try {
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestProperty("X-Requested-With", "Curl");
                        connection.setRequestMethod("GET");
                        basicAuth = "Basic " + new String(Base64.getEncoder().encode(this.getUsernameAndPassword().getBytes()));
                        connection.setRequestProperty("Authorization", basicAuth);
                        if (connection.getResponseCode() != 200) continue;
                        usedSpace += (long)connection.getInputStream().available();
                    }
                    catch (IOException e) {
                        CommonCore.getLogManager().log((Exception)e);
                    }
                }
                catch (MalformedURLException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
            }
        }
        return usedSpace;
    }

    @Override
    protected HashMap<String, HashSet<String>> getPreviousBuckets(boolean already_locked) {
        HashMap<String, HashSet<String>> ret = new HashMap<String, HashSet<String>>();
        return ret;
    }

    @Override
    protected void updatePreviousBuckets(HashMap<String, HashSet<String>> data) {
    }
}

