/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice.json.stats;

import com.ibm.appscan.common.utils.IOUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SlicerGeneralStats {
    private File m_prepare_stats;
    private File m_analyze_stats;

    public SlicerGeneralStats(File prepare_stats, File analyze_stats) {
        this.m_prepare_stats = prepare_stats;
        this.m_analyze_stats = analyze_stats;
    }

    public void saveGeneralStats(File target) throws JSONException, IOException {
        JSONObject prepare = new JSONObject(IOUtil.readFileIntoString((File)this.m_prepare_stats));
        JSONObject analyze = new JSONObject(IOUtil.readFileIntoString((File)this.m_analyze_stats));
        JSONObject general = new JSONObject();
        int bucket_count = prepare.getInt("slice.buckets");
        general.put("slice.buckets", bucket_count);
        general.put("slice.class.file.count", prepare.get("slice.class.file.count"));
        general.put("slice.ir.prepare.wafl.gen.time.ms", prepare.get("wafl.gen.time"));
        general.put("slice.ir.prepare.cache.hit.percent", this.getCacheHitsPercent(prepare, bucket_count));
        general.put("slice.ir.prepare.total.time.ms", prepare.get("slice.total.run.time"));
        general.put("slice.ir.analyze.total.time.ms", analyze.get("slice.ir.analyze.time"));
        general.put("slice.ir.analyze.assmt.combine.time.ms", analyze.get("slice.ir.assmt.combine.time"));
        general.put("slice.ir.analyze.cache.hit.percent", this.getCacheHitsPercent(analyze, bucket_count));
        IOUtil.write((String)general.toString(true), (File)target);
    }

    private int getCacheHitsPercent(JSONObject obj, double bucket_count) throws JSONException {
        int cache_hits = 0;
        JSONArray prepare_buckets = obj.getJSONArray("buckets");
        for (int i = 0; i < prepare_buckets.length(); ++i) {
            Object b = prepare_buckets.get(i);
            if (!((JSONObject)b).getBoolean("in.cache")) continue;
            ++cache_hits;
        }
        return (int)((double)cache_hits / bucket_count * 100.0);
    }
}

