/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice.wafl;

import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.slice.Bucket;
import com.hcl.irx.slice.wafl.WaflReader;
import com.hcl.irx.stage.Stager;
import com.hcl.irx.stage.java.JavaStager;
import com.ibm.appscan.common.utils.IOUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SliceWafl {
    private Bucket m_bucket;
    private String m_master_wafl;
    private File m_master_wafl_file;
    private String m_bucket_classesRegex;
    private JavaStager m_stager;
    private WaflReader m_wafl_reader;

    public SliceWafl(File master_wafl, Stager stager, Bucket b) throws IOException {
        this.m_master_wafl = new String(Files.readAllBytes(Paths.get(master_wafl.getAbsolutePath(), new String[0])));
        this.m_bucket = b;
        this.m_stager = (JavaStager)stager;
        this.m_master_wafl_file = master_wafl;
    }

    private String getBucketClassesRegex() throws IOException {
        if (this.m_bucket_classesRegex == null) {
            StringBuilder str = new StringBuilder();
            str.append("(");
            for (ClassInfo classInfo : this.m_bucket.getClassesInBucket()) {
                str.append(classInfo.getClassName());
                str.append("|");
                if (this.getWaflReader().getClassNameToGlobalEntryMap().containsKey(classInfo.getClassName())) {
                    str.append(this.getWaflReader().getClassNameToGlobalEntryMap().get(classInfo.getClassName()));
                    str.append("|");
                }
                if (!this.getWaflReader().getDependencies().containsKey(classInfo.getClassName())) continue;
                for (String depend : this.getWaflReader().getDependencies().get(classInfo.getClassName())) {
                    if (!depend.startsWith("AppScan.Synthetic")) continue;
                    str.append(depend);
                    str.append("|");
                }
            }
            str.deleteCharAt(str.length() - 1);
            str.append(")");
            this.m_bucket_classesRegex = str.toString();
        }
        return this.m_bucket_classesRegex;
    }

    public File getWaflForSlice() throws IOException {
        File wafl_for_slice = new File(this.m_bucket.getBucketDir(), "_frameworks_slice.wafl");
        StringBuilder str = new StringBuilder();
        str.append("<wafl xmlns=\"http://www.ibm.com/WAFLSchema\">");
        str.append(System.lineSeparator());
        str.append(this.getExternalBeanDecls());
        str.append(this.getSyntheticMethodsSpecificToSlice());
        str.append(this.getExternalCallsSpecificToSlice());
        str.append(this.getCallReplacementsSpecificToSlice());
        str.append("</wafl>");
        IOUtil.write((String)str.toString(), (File)wafl_for_slice);
        return wafl_for_slice;
    }

    private String getExternalBeanDecls() throws IOException {
        StringBuilder ret = new StringBuilder();
        ret.append("  <global-bean-decls>");
        Matcher m = Pattern.compile("\\s*<object-decl.*?type=\\\"(.*?)\\\".*?>.*?<\\/object-decl>", 42).matcher(this.m_master_wafl);
        while (m.find()) {
            if (!this.m_stager.getAnalysisPackages().contains(m.group(1).substring(0, m.group(1).lastIndexOf(".")))) {
                ret.append(m.group());
                continue;
            }
            Matcher external_decl_in_bucket = Pattern.compile(this.getBucketClassesRegex()).matcher(m.group(1));
            if (!external_decl_in_bucket.find()) continue;
            ret.append(m.group());
        }
        ret.append(System.lineSeparator());
        ret.append("</global-bean-decls>");
        ret.append(System.lineSeparator());
        return ret.toString();
    }

    private WaflReader getWaflReader() throws IOException {
        if (this.m_wafl_reader == null) {
            try {
                this.m_wafl_reader = new WaflReader(this.m_master_wafl_file, this.m_stager);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return this.m_wafl_reader;
    }

    private boolean processGroupForSlice(String child_element_name, StringBuilder ret, boolean trailing_new_line) throws IOException {
        boolean added_entry = false;
        Matcher m = Pattern.compile("\\s*?<" + child_element_name + ".*?>(.*?)<\\/" + child_element_name.trim() + ">", 42).matcher(this.m_master_wafl);
        while (m.find()) {
            Matcher synth_applies_to_bucket = Pattern.compile(this.getBucketClassesRegex() + "(\\.|\"|\\()", 42).matcher(m.group());
            if (!synth_applies_to_bucket.find()) continue;
            ret.append(m.group());
            added_entry = true;
            if (!trailing_new_line) continue;
            ret.append(System.lineSeparator());
        }
        return added_entry;
    }

    private String getSyntheticMethodsSpecificToSlice() throws IOException {
        StringBuilder ret = new StringBuilder();
        ret.append("  <synthetic-methods>");
        this.processGroupForSlice("synthetic-method ", ret, false);
        ret.append(System.lineSeparator());
        ret.append("  </synthetic-methods>");
        ret.append(System.lineSeparator());
        return ret.toString();
    }

    private String getExternalCallsSpecificToSlice() throws IOException {
        StringBuilder ret = new StringBuilder();
        ret.append("  <entrypoints>");
        if (!this.processGroupForSlice("entrypoint ", ret, true)) {
            ret.append(System.lineSeparator());
        }
        ret.append("  </entrypoints>");
        ret.append(System.lineSeparator());
        return ret.toString();
    }

    private String getCallReplacementsSpecificToSlice() throws IOException {
        StringBuilder ret = new StringBuilder();
        ret.append("  <call-replacements>");
        this.processGroupForSlice("replace-call", ret, false);
        ret.append(System.lineSeparator());
        ret.append("  </call-replacements>");
        ret.append(System.lineSeparator());
        return ret.toString();
    }
}

