/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice.xml;

import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.slice.Bucket;
import com.hcl.irx.stage.Stager;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.common.xml.XmlFileWriter;
import java.io.File;
import java.util.ArrayList;

public class TargetInfoSliceXml
extends XmlFileWriter {
    private Stager m_stager;
    private IScanTargetMinProxy m_proxy;
    private Bucket m_bucket;

    public TargetInfoSliceXml(File output_xml, IScanTargetMinProxy proxy, Bucket bucket, Stager stager) {
        super(output_xml);
        this.m_proxy = proxy;
        this.m_bucket = bucket;
        this.m_stager = stager;
    }

    protected void writeXml(DOMWriter writer) {
        writer.beginElement("Target");
        writer.setAttribute("language_type", "Java");
        writer.setAttribute("name", "analyze");
        writer.setAttribute("path", ".");
        writer.setAttribute("strategy", "com.ibm.appscan.internal.discovery.dir.DirectoryStrategy");
        writer.setAttribute("type", "bytecode");
        writer.setAttribute("working_directory", "./");
        writer.beginElement("BuildInfo");
        ArrayList<String> entries = new ArrayList<String>();
        entries.add("additional_classpath");
        entries.add("bootstrap_classpath");
        entries.add("classpath");
        entries.add("extension_jars");
        entries.add("jsp_compiler");
        entries.add("web_content_dir");
        entries.add("web_server_type");
        entries.add("src_root");
        for (String string : entries) {
            if (this.m_proxy == null || this.m_proxy.getBuildInfo().getProperty(string) == null) continue;
            writer.setAttribute(string, this.m_proxy.getBuildInfo().getProperty(string));
        }
        writer.endElement();
        for (ClassInfo classInfo : this.m_bucket.getClassesInBucket()) {
            writer.beginElement("ScanFile");
            writer.setAttribute("analysis_path", this.getRelativePathToBasePath(classInfo.getOriginalFileLocation()));
            writer.setAttribute("src_path", (String)this.m_stager.getStagedFilesMap().get(classInfo.getOriginalFileLocation().getAbsolutePath()));
            writer.endElement();
        }
        writer.endElement();
    }

    protected String getFileName() {
        return ".targetinfo";
    }
}

