/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.struts2;

import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.F4FHandler;
import com.ibm.appscan.frameworks.highlevelapi.Global;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.EnclosingFormal;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Taint;
import com.ibm.appscan.frameworks.java.WAFLSpecGen;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.StringStuff;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class Struts2Handler
extends F4FHandler {
    private static final Logger logger = TaintLogger.i().getLogger();
    private boolean usingConvention;
    private ConventionActionInfo conventionActionInfo;
    private IJSPPrecompilerInfo jspInfo;
    private static final boolean ALWAYS_USE_CONVENTION = true;

    public void handleApp(F4FApp app, F4FActions actions) {
        try {
            logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"STRUTS2", "handleApp()"}));
            this.init(app);
            Collection<Object> actionClasses = this.usingConvention ? this.scanForConventionActionClasses(app) : Collections.emptySet();
            for (IClass action : actionClasses) {
                logger.info((Object)Messages.getString((String)"framework.processing.class", (Object[])new Object[]{action.getName().toString()}));
                ArrayList<IMethod> setters = new ArrayList<IMethod>();
                IMethod executeMethod = null;
                IMethod validateMethod = null;
                for (IMethod theMethod : action.getDeclaredMethods()) {
                    if (this.isSetterMethod(theMethod)) {
                        logger.info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{theMethod.getSignature()}));
                        setters.add(theMethod);
                        continue;
                    }
                    if (this.isActionExecuteMethod(theMethod)) {
                        logger.info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{theMethod.getSignature()}));
                        executeMethod = theMethod;
                        continue;
                    }
                    if (!this.isActionValidateMethod(theMethod)) continue;
                    logger.info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{theMethod.getSignature()}));
                    validateMethod = theMethod;
                }
                if (executeMethod == null) continue;
                HighLevelSyntheticMethod s = HighLevelSyntheticMethod.make((String)this.generateSynthMethodName(action));
                logger.info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{s.getVdbSignature()}));
                logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{action.getName().toString()}));
                Local actionObj = s.newLocal(action);
                for (IMethod setter : setters) {
                    logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{"parameter1", "1"}));
                    logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{setter.getSignature()}));
                    s.addCall(setter, null, new Param[]{actionObj, Taint.taint()});
                }
                if (validateMethod != null) {
                    logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{validateMethod.getSignature()}));
                    s.addCall(validateMethod, null, new Param[]{actionObj});
                }
                logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{executeMethod.getSignature()}));
                s.addCall(executeMethod, null, new Param[]{actionObj});
                this.addCallsForJSPForwards(s, action, executeMethod, setters, actionObj, app, actions);
                logger.info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{s.getVdbSignature()}));
                actions.addHighLevelSyntheticMethod(s);
            }
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"STRUTS2"}));
    }

    private void addCallsForJSPForwards(HighLevelSyntheticMethod s, IClass action, IMethod executeMethod, List<IMethod> setters, Local actionObj, F4FApp app, F4FActions actions) {
        IClassHierarchy cha = app.getClassHierarchy();
        for (IMethod setter : setters) {
            String nm = setter.getName().toString();
            String propNameCapital = nm.substring(3);
            String getterName = "get" + propNameCapital;
            Collection getterMethods = app.getClassMethods(action, getterName);
            if (getterMethods.size() != 1) continue;
            IMethod getter = (IMethod)getterMethods.iterator().next();
            String globalName = "request." + WordUtils.uncapitalize((String)propNameCapital);
            logger.info((Object)Messages.getString((String)"framework.generate.global", (Object[])new Object[]{globalName}));
            Global g = actions.createGlobal(globalName, VDBJavaUtil.jvmToVDBType((String)getter.getReturnType().getName().toString()), true);
            logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{getter.getSignature()}));
            Local getterResult = s.addCall(getter, null, new Param[]{actionObj});
            logger.info((Object)Messages.getString((String)"framework.generate.write", (Object[])new Object[]{g.getName()}));
            s.addGlobalWrite(g, getterResult, null);
        }
        Collection viewNames = app.getStringConstantsReturnedByMethod(executeMethod);
        String viewPrefix = this.conventionActionInfo.getActionViewPrefix(executeMethod.getDeclaringClass());
        if (viewPrefix == null) {
            return;
        }
        for (String viewName : viewNames) {
            String jspFileName = "/WEB-INF/content/" + viewPrefix + "-" + viewName + ".jsp";
            String precompiledClassNameForJSP = this.jspInfo.getPrecompiledClassNameForJSP(jspFileName);
            IClass jspClass = app.getIClass(precompiledClassNameForJSP);
            if (jspClass == null) continue;
            for (Selector selector : this.jspInfo.getEntrypointSelectors()) {
                MethodReference ref = MethodReference.findOrCreate((TypeReference)jspClass.getReference(), (Selector)selector);
                IMethod m = cha.resolveMethod(ref);
                if (m == null) continue;
                logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{m.getSignature()}));
                s.addCall(m, null, new Param[]{EnclosingFormal.FIRST, EnclosingFormal.SECOND});
            }
        }
    }

    private boolean isActionValidateMethod(IMethod theMethod) {
        return !theMethod.isStatic() && theMethod.getSelector().toString().equals("validate()V");
    }

    private boolean isActionExecuteMethod(IMethod theMethod) {
        return !theMethod.isStatic() && theMethod.getSelector().toString().equals("execute()Ljava/lang/String;");
    }

    private boolean isSetterMethod(IMethod theMethod) {
        return !theMethod.isStatic() && theMethod.getNumberOfParameters() == 2 && theMethod.getReturnType().equals((Object)TypeReference.Void) && theMethod.getName().toString().startsWith("set");
    }

    private String generateSynthMethodName(IClass action) {
        return "AppScan.Synthetic.Struts2." + StringStuff.jvmToReadableType((String)action.getName().toString()).replace('.', '_').replace('$', '_') + "_Request(javax.servlet.http.HttpServletRequest;javax.servlet.http.HttpServletResponse):void";
    }

    private Collection<IClass> scanForConventionActionClasses(F4FApp app) {
        ArrayList<IClass> result = new ArrayList<IClass>();
        TypeReference ref = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)"Lcom/opensymphony/xwork2/Action");
        IClassHierarchy cha = app.getClassHierarchy();
        IClass actionInterface = cha.lookupClass(ref);
        for (IClass klass : app.getAllApplicationClasses()) {
            if (actionInterface != null && cha.isAssignableFrom(actionInterface, klass)) {
                logger.info((Object)Messages.getString((String)"framework.found.class", (Object[])new Object[]{klass.getName().toString()}));
                result.add(klass);
                continue;
            }
            String readableName = StringStuff.jvmToReadableType((String)klass.getName().toString());
            if (!this.conventionActionInfo.isActionClass(klass) || !readableName.endsWith("Action")) continue;
            logger.info((Object)Messages.getString((String)"framework.found.class", (Object[])new Object[]{klass.getName().toString()}));
            result.add(klass);
        }
        return result;
    }

    private void init(F4FApp app) {
        this.usingConvention = this.isUsingConventionPlugin(app);
        if (this.usingConvention) {
            this.conventionActionInfo = new ConventionActionInfo(){
                private Pattern actionPackagePattern;
                {
                    this.actionPackagePattern = Struts2Handler.this.initActionPackagePattern();
                }

                @Override
                public boolean isActionClass(IClass klass) {
                    String readableName = StringStuff.jvmToReadableType((String)klass.getName().toString());
                    return this.actionPackagePattern.matcher(readableName).find();
                }

                @Override
                public String getActionViewPrefix(IClass klass) {
                    String readableName = StringStuff.jvmToReadableType((String)klass.getName().toString());
                    Matcher matcher = this.actionPackagePattern.matcher(readableName);
                    if (!matcher.find()) {
                        return null;
                    }
                    String result = matcher.group(3);
                    if (!result.endsWith("Action")) {
                        return null;
                    }
                    String className = result.substring(result.lastIndexOf(46) + 1);
                    String tmp = WordUtils.uncapitalize((String)className);
                    tmp = tmp.replace("Action", "");
                    result = result.replace(className, tmp).replace('.', '/');
                    return result;
                }
            };
        }
        this.jspInfo = JavaEEOptions.getPrecompilerInfo((Properties)this.getFrameworksInput().getOptions());
    }

    private boolean isUsingConventionPlugin(F4FApp app) {
        return true;
    }

    private Pattern initActionPackagePattern() {
        return Pattern.compile("(.*\\.)?(struts|struts2|action|actions)\\.(.*)");
    }

    public boolean isApplicable() {
        logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"STRUTS2", "isApplicable()"}));
        FrameworksInput input = this.getFrameworksInput();
        if (input.getType().equals("Java")) {
            try {
                IJavaEEDeploymentDescriptorInfo ddInfo = WAFLSpecGen.getDDInfo((String)input.getFileLocs().getWebContentDir());
                if (ddInfo != null) {
                    Collection filterClassNames = ddInfo.getAllFilterClassNames();
                    logger.info((Object)Messages.getString((String)"framework.handler.searching", (Object[])new Object[]{"org.apache.struts2.dispatcher.ng.filter.StrutsPrepareAndExecuteFilter or org.apache.struts2.dispatcher.FilterDispatcher", input.getFileLocs().getWebContentDir() + File.separator + "WEB-INF" + File.separator + "web.xml"}));
                    boolean result = filterClassNames.contains("org.apache.struts2.dispatcher.ng.filter.StrutsPrepareAndExecuteFilter") || filterClassNames.contains("org.apache.struts2.dispatcher.FilterDispatcher");
                    logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", Boolean.toString(result)}));
                    if (!result) {
                        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"STRUTS2"}));
                    }
                    return result;
                }
            }
            catch (IOException e) {
                logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            }
            catch (SAXException e) {
                logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            }
        }
        logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"STRUTS2"}));
        return false;
    }

    static interface ConventionActionInfo {
        public boolean isActionClass(IClass var1);

        public String getActionViewPrefix(IClass var1);
    }
}

