/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.aspdotnet;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetWalaUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.Utils;
import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.FrameworkInfoImpl;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.ReturnExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticMethodImpl;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.intset.IntSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AspDotNetValidationAndEncoding {
    private static final Logger logger = TaintLogger.i().getLogger();
    private static final Collection<String> REQUEST_VALIDATED_STRING_METHODS = AspDotNetValidationAndEncoding.readAllFileLinesIntoCollection("requestValidatedStringMethods.txt");
    private static final Collection<String> REQUEST_VALIDATED_NVC_METHODS = AspDotNetValidationAndEncoding.readAllFileLinesIntoCollection("requestValidatedNameValueCollectionMethods.txt");
    private static final String VALIDATE_STRING_METHOD_NAME = "requestValidateString";
    private static final ISyntheticMethod VALIDATE_STRING_METHOD = AspDotNetValidationAndEncoding.createValidateStringMethod();
    private static final String VALIDATE_NVC_METHOD_NAME = "requestValidateNameValueCollection";
    private static final ISyntheticMethod VALIDATE_NAMEVALUECOLLECTION_METHOD = AspDotNetValidationAndEncoding.createValidateNameValueCollectionMethod();
    private static final String SET_CONTROL_TO_VALIDATE_SIG = "System.Web.UI.WebControls.BaseValidator.set_ControlToValidate(LSystem/String;)PSystem/Void;";
    private final IClassHierarchy cha;
    private final AnalysisCache cache;
    private static final Collection<String> SINKS_WITH_HTML_ENCODING = AspDotNetValidationAndEncoding.readAllFileLinesIntoCollection("sinksWithHTMLEncoding.txt");
    private static final Collection<String> POSSIBLY_VALIDATED_CONTROL_METHODS = AspDotNetValidationAndEncoding.readAllFileLinesIntoCollection("possiblyValidatedControlMethods.txt");

    public static AspDotNetValidationAndEncoding make(IClassHierarchy cha, AnalysisCache cache) {
        return new AspDotNetValidationAndEncoding(cha, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> readAllFileLinesIntoCollection(String fileName) {
        HashSet result = HashSetFactory.make();
        BufferedReader reader = null;
        InputStream isFile = null;
        try {
            String line;
            URL urlFile = AspDotNetValidationAndEncoding.class.getClassLoader().getResource(fileName);
            isFile = urlFile.openStream();
            reader = new BufferedReader(new InputStreamReader(isFile));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (isFile != null) {
                try {
                    isFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private static ISyntheticMethod createValidateStringMethod() {
        String signature = "AppScan.Synthetic.dotNet.requestValidateString(System.String):System.String";
        logger.info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{signature}));
        ArrayList<Object> statements = new ArrayList<Object>(2);
        logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Web.HttpRequest.ValidateString(System.String;System.String;System.String):System.Void"}));
        InvokeExpr invokeExpr = InvokeExpr.createInvokeExpr(null, (String)"System.Web.HttpRequest.ValidateString(System.String;System.String;System.String):System.Void", Collections.singletonMap(0, FormalParameterExpr.make((int)0)));
        statements.add(invokeExpr);
        ReturnExpr returnExpr = ReturnExpr.make(null, (ObjectRefExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)""));
        statements.add(returnExpr);
        logger.info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{signature}));
        return new SyntheticMethodImpl(signature, Collections.emptySet(), statements);
    }

    private static ISyntheticMethod createValidateNameValueCollectionMethod() {
        String signature = "AppScan.Synthetic.dotNet.requestValidateNameValueCollection(System.Collections.Specialized.NameValueCollection):System.Collections.Specialized.NameValueCollection";
        logger.info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{signature}));
        ArrayList<Object> statements = new ArrayList<Object>(2);
        logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Web.HttpRequest.ValidateNameValueCollection(System.Collections.Specialized.NameValueCollection;System.String):System.Void"}));
        InvokeExpr invokeExpr = InvokeExpr.createInvokeExpr(null, (String)"System.Web.HttpRequest.ValidateNameValueCollection(System.Collections.Specialized.NameValueCollection;System.String):System.Void", Collections.singletonMap(0, FormalParameterExpr.make((int)0)));
        statements.add(invokeExpr);
        ReturnExpr returnExpr = ReturnExpr.make(null, (ObjectRefExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)""));
        statements.add(returnExpr);
        logger.info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{signature}));
        return new SyntheticMethodImpl(signature, Collections.emptySet(), statements);
    }

    private AspDotNetValidationAndEncoding(IClassHierarchy cha, AnalysisCache cache) {
        this.cha = cha;
        this.cache = cache;
    }

    public IFrameworkInfo handleValidationAndEncoding() {
        HashMap replacements = HashMapFactory.make();
        HashSet syntheticMethods = HashSetFactory.make();
        for (IClass klass : DotNetWalaUtil.getApplicationClasses(this.cha)) {
            if (!this.isASPXClass(klass)) continue;
            logger.info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{klass.getName().toString()}));
            boolean requestValidationEnabled = this.requestValidationEnabled(klass);
            Map<String, Set<ValidatorType>> control2ValidatorTypes = this.computeControl2ValidatorTypes(klass);
            for (IMethod m : this.getMethodsInWhichToReplaceCalls(klass)) {
                this.addReplacementsForMethod(m, requestValidationEnabled, control2ValidatorTypes, replacements, syntheticMethods);
            }
        }
        return new FrameworkInfoImpl((Set)syntheticMethods, Collections.emptySet(), Collections.emptyMap(), (Map)replacements);
    }

    private Map<String, Set<ValidatorType>> computeControl2ValidatorTypes(IClass klass) {
        HashMap result = HashMapFactory.make();
        for (IMethod m : klass.getDeclaredMethods()) {
            String returnTypeName = m.getReturnType().getName().toString();
            for (ValidatorType t : ValidatorType.values()) {
                if (!returnTypeName.equals(t.dotNetType)) continue;
                IR ir = LangIndependentWalaUtil.getIR((IMethod)m, (AnalysisCache)this.cache);
                SSAInstruction[] instructions = ir.getInstructions();
                for (CallSiteReference site : Iterator2Iterable.make((Iterator)ir.iterateCallSites())) {
                    String targetSig = site.getDeclaredTarget().getSignature();
                    if (!targetSig.equals(SET_CONTROL_TO_VALIDATE_SIG)) continue;
                    IntSet callInstructionIndices = ir.getCallInstructionIndices(site);
                    assert (callInstructionIndices.size() == 1);
                    SSAInstruction callInstr = instructions[callInstructionIndices.intIterator().next()];
                    int controlNameVN = callInstr.getUse(1);
                    StringConstantFlow stringConstantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)this.cache));
                    Collection stringsFlowingToVar = stringConstantFlow.findIntraprocStringsFlowingToVar(controlNameVN);
                    for (String validatedControlName : stringsFlowingToVar) {
                        MapUtil.findOrCreateSet((Map)result, (Object)validatedControlName).add(t);
                    }
                }
            }
        }
        return result;
    }

    private void addReplacementsForMethod(IMethod m, boolean requestValidationEnabled, Map<String, Set<ValidatorType>> control2ValidatorTypes, Map<String, Set<CallSiteReplacement>> replacements, Set<ISyntheticMethod> syntheticMethods) {
        IR ir = LangIndependentWalaUtil.getIR((IMethod)m, (AnalysisCache)this.cache);
        if (ir == null) {
            TaintLogger.i().getLogger().warn((Object)("null IR for method " + m));
            return;
        }
        String callerVDBSig = DotNetVDBUtil.walaDotNet2FullyQualifiedVDBSignature(m.getSignature());
        for (CallSiteReference site : Iterator2Iterable.make((Iterator)ir.iterateCallSites())) {
            String unqualifiedVDBTarget = DotNetVDBUtil.walaDotNet2VDBSignature(site.getDeclaredTarget().getSignature());
            this.handleValidatedSourceCalls(m, requestValidationEnabled, control2ValidatorTypes, replacements, syntheticMethods, ir, callerVDBSig, site, unqualifiedVDBTarget);
            this.handleCallsToSinksWithHTMLEncoding(m, replacements, callerVDBSig, site, unqualifiedVDBTarget);
        }
    }

    private void handleCallsToSinksWithHTMLEncoding(IMethod m, Map<String, Set<CallSiteReplacement>> replacements, String callerVDBSig, CallSiteReference site, String unqualifiedVDBTarget) {
        if (this.isSinkWithHTMLEncoding(unqualifiedVDBTarget)) {
            String qualifiedVDBTarget = DotNetVDBUtil.unqualified2QualifiedVDBSignature(unqualifiedVDBTarget);
            int srcLine = m.getLineNumber(site.getProgramCounter());
            HashMap actualParameterPos2Value = HashMapFactory.make();
            actualParameterPos2Value.put(0, ArgToOrigCallExpr.make((int)0));
            String htmlEncodeSig = "System.Web.HttpUtility.HtmlEncode(System.String):System.String";
            Map<Integer, ArgToOrigCallExpr> encodeArgs = Collections.singletonMap(0, ArgToOrigCallExpr.make((int)1));
            InvokeExpr htmlEncodedArgExpr = InvokeExpr.createInvokeExpr((FilePositionInfo)Utils.getMethodPosition(m, srcLine), (String)htmlEncodeSig, encodeArgs);
            actualParameterPos2Value.put(1, htmlEncodedArgExpr);
            InvokeExpr replacementExpr = InvokeExpr.createInvokeExpr((FilePositionInfo)Utils.getMethodPosition(m, srcLine), (String)qualifiedVDBTarget, (Map)actualParameterPos2Value);
            MapUtil.findOrCreateSet(replacements, (Object)callerVDBSig).add(CallSiteReplacement.make((String)qualifiedVDBTarget, (int)site.getProgramCounter(), (int)srcLine, (SyntheticExpr)replacementExpr));
        }
    }

    private boolean isSinkWithHTMLEncoding(String vdbTarget) {
        return SINKS_WITH_HTML_ENCODING.contains(vdbTarget);
    }

    private void handleValidatedSourceCalls(IMethod m, boolean requestValidationEnabled, Map<String, Set<ValidatorType>> control2ValidatorTypes, Map<String, Set<CallSiteReplacement>> replacements, Set<ISyntheticMethod> syntheticMethods, IR ir, String callerVDBSig, CallSiteReference site, String unqualifiedVDBTarget) {
        Set<ValidatorType> validatorTypes;
        String controlName;
        ArrayList<ISyntheticMethod> synthMethodWrappers = new ArrayList<ISyntheticMethod>(1);
        if (requestValidationEnabled) {
            if (REQUEST_VALIDATED_STRING_METHODS.contains(unqualifiedVDBTarget)) {
                synthMethodWrappers.add(VALIDATE_STRING_METHOD);
            }
            if (REQUEST_VALIDATED_NVC_METHODS.contains(unqualifiedVDBTarget)) {
                synthMethodWrappers.add(VALIDATE_NAMEVALUECOLLECTION_METHOD);
            }
        }
        if (this.isPossiblyValidatedControlMethod(unqualifiedVDBTarget) && (controlName = this.getControlName(site, ir)) != null && (validatorTypes = control2ValidatorTypes.get(controlName)) != null) {
            for (ValidatorType t : validatorTypes) {
                synthMethodWrappers.add(t.synthMethod);
            }
        }
        if (!synthMethodWrappers.isEmpty()) {
            this.wrapWithCallsToSyntheticMethods(m, replacements, syntheticMethods, callerVDBSig, site, DotNetVDBUtil.unqualified2QualifiedVDBSignature(unqualifiedVDBTarget), synthMethodWrappers);
        }
    }

    private String getControlName(CallSiteReference site, IR ir) {
        SSAGetInstruction getInstr;
        IntSet callInstructionIndices = ir.getCallInstructionIndices(site);
        assert (callInstructionIndices.size() >= 1);
        if (callInstructionIndices.size() > 1) {
            logger.debug((Object)("getControlName() has " + callInstructionIndices.size() + " indices at  " + site.toString()));
        }
        SSAInstruction callInstr = ir.getInstructions()[callInstructionIndices.intIterator().next()];
        int receiverVN = callInstr.getUse(0);
        DefUse defUse = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)this.cache);
        SSAInstruction receiverDef = defUse.getDef(receiverVN);
        if (receiverDef instanceof SSAGetInstruction && !(getInstr = (SSAGetInstruction)receiverDef).isStatic()) {
            return getInstr.getDeclaredField().getName().toString();
        }
        return null;
    }

    private boolean isPossiblyValidatedControlMethod(String vdbTarget) {
        return POSSIBLY_VALIDATED_CONTROL_METHODS.contains(vdbTarget);
    }

    private void wrapWithCallsToSyntheticMethods(IMethod m, Map<String, Set<CallSiteReplacement>> replacements, Set<ISyntheticMethod> syntheticMethods, String callerVDBSig, CallSiteReference site, String qualifiedVDBTarget, List<ISyntheticMethod> synthMethodWrappers) {
        FilePositionInfo filePosInfo = Utils.getMethodPosition(m);
        InvokeExpr rhsInvoke = this.origInvoke(site, filePosInfo);
        for (ISyntheticMethod wrapper : synthMethodWrappers) {
            HashMap paramsToValidator = HashMapFactory.make();
            paramsToValidator.put(0, rhsInvoke);
            rhsInvoke = InvokeExpr.createInvokeExpr((FilePositionInfo)filePosInfo, (String)wrapper.getSignature(), (Map)paramsToValidator);
        }
        int srcLine = m.getLineNumber(site.getProgramCounter());
        AssignmentExpr replacementExpr = AssignmentExpr.make((FilePositionInfo)Utils.getMethodPosition(m, srcLine), (AssignableSyntheticExpr)ArgToOrigCallExpr.make((int)-1), (NonVoidSyntheticExpr)rhsInvoke);
        MapUtil.findOrCreateSet(replacements, (Object)callerVDBSig).add(CallSiteReplacement.make((String)qualifiedVDBTarget, (int)site.getProgramCounter(), (int)srcLine, (SyntheticExpr)replacementExpr));
        syntheticMethods.addAll(synthMethodWrappers);
    }

    private InvokeExpr origInvoke(CallSiteReference site, FilePositionInfo filePosInfo) {
        MethodReference declaredTarget = site.getDeclaredTarget();
        int numParams = declaredTarget.getNumberOfParameters();
        if (!site.isStatic()) {
            ++numParams;
        }
        return InvokeExpr.createInvokeExprWithOrigArgs((FilePositionInfo)filePosInfo, (String)DotNetVDBUtil.walaDotNet2FullyQualifiedVDBSignature(declaredTarget.getSignature()), (int)numParams);
    }

    private Collection<IMethod> getMethodsInWhichToReplaceCalls(IClass klass) {
        HashSet result = HashSetFactory.make();
        for (IClass tmp = klass; tmp != null && klass.getClassHierarchy().getScope().isApplicationLoader(tmp.getClassLoader()); tmp = tmp.getSuperclass()) {
            result.addAll(tmp.getDeclaredMethods());
        }
        return result;
    }

    private boolean isASPXClass(IClass klass) {
        IClass pageKlass = DotNetWalaUtil.getIClass("System.Web.UI.Page", "System.Web", this.cha);
        return pageKlass != null && this.cha.isAssignableFrom(pageKlass, klass) && this.cha.getImmediateSubclasses(klass).isEmpty();
    }

    private boolean requestValidationEnabled(IClass klass) {
        for (IMethod m : klass.getDeclaredMethods()) {
            if (m.isStatic() || !m.getName().toString().equals("FrameworkInitialize")) continue;
            IR ir = LangIndependentWalaUtil.getIR((IMethod)m, (AnalysisCache)this.cache);
            for (CallSiteReference site : Iterator2Iterable.make((Iterator)ir.iterateCallSites())) {
                if (!site.getDeclaredTarget().getSignature().equals("System.Web.HttpRequest.ValidateInput()PSystem/Void;")) continue;
                return true;
            }
        }
        return false;
    }

    public static enum ValidatorType {
        COMPARE("LSystem/Web/UI/WebControls/CompareValidator", "Compare"),
        CUSTOM("LSystem/Web/UI/WebControls/CustomValidator", "Custom"),
        RANGE("LSystem/Web/UI/WebControls/RangeValidator", "Range"),
        REGEXP("LSystem/Web/UI/WebControls/RegularExpressionValidator", "RegExp"),
        REQUIRED_FIELD("LSystem/Web/UI/WebControls/RequiredFieldValidator", "RequiredField");

        final String dotNetType;
        final ISyntheticMethod synthMethod;

        private ValidatorType(String dotNetType, String shortName) {
            this.dotNetType = dotNetType;
            this.synthMethod = this.createValidatorSyntheticMethod(shortName);
        }

        private ISyntheticMethod createValidatorSyntheticMethod(String shortName) {
            String synthMethodName = "AppScan.Synthetic.dotNet.run" + shortName;
            String signature = synthMethodName + "(System.String):System.String";
            logger.info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{signature}));
            List<ReturnExpr> statements = Collections.singletonList(ReturnExpr.make(null, (ObjectRefExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)"")));
            logger.info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{signature}));
            return new SyntheticMethodImpl(signature, Collections.emptySet(), statements);
        }
    }
}

