/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.aspdotnet.util;

import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.dotnet.loader.AbstractLowLevelInterface;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.jstaint.util.scopes.ScopeUtil;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.PlatformUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DotNetWalaUtil {
    public static ClassLoaderReference getLoaderForAssembly(String assemblyName, AnalysisScope scope) {
        for (ClassLoaderReference cl : scope.getLoaders()) {
            String clName = cl.getName().toString();
            if (clName.contains(",")) {
                clName = clName.substring(0, clName.indexOf(","));
            }
            if (!clName.equals(assemblyName)) continue;
            scope.getLoaderImpl(cl);
            return cl;
        }
        return null;
    }

    public static IClass getIClass(String typeName, String assemblyName, IClassHierarchy cha) {
        ClassLoaderReference loaderForAssembly = DotNetWalaUtil.getLoaderForAssembly(assemblyName, cha.getScope());
        if (loaderForAssembly == null) {
            return null;
        }
        return cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)loaderForAssembly, (String)DotNetVDBUtil.vdb2WalaDotNetType(typeName)));
    }

    public static IClass getApplicationClass(String typeName, IClassHierarchy cha) {
        String internalTypeName = DotNetVDBUtil.vdb2WalaDotNetType(typeName);
        for (IClassLoader cl : cha.getLoaders()) {
            TypeReference ref;
            IClass klass;
            if (!cha.getScope().isApplicationLoader(cl) || (klass = cha.lookupClass(ref = TypeReference.findOrCreate((ClassLoaderReference)cl.getReference(), (String)internalTypeName))) == null) continue;
            return klass;
        }
        return null;
    }

    public static IClass getIClass(String typeName, IClassHierarchy cha) {
        IClass appClass = DotNetWalaUtil.getApplicationClass(typeName, cha);
        if (appClass != null) {
            return appClass;
        }
        String internalTypeName = DotNetVDBUtil.vdb2WalaDotNetType(typeName);
        for (IClassLoader cl : cha.getLoaders()) {
            TypeReference ref;
            IClass klass;
            if (cha.getScope().isApplicationLoader(cl) || (klass = cha.lookupClass(ref = TypeReference.findOrCreate((ClassLoaderReference)cl.getReference(), (String)internalTypeName))) == null) continue;
            return klass;
        }
        return null;
    }

    public static CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer> getDotNetAnalysisScope(String scopeFileName) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(scopeFileName), "UTF-8"));
        String f = "";
        if (!in.ready()) {
            throw new IOException();
        }
        while ((f = in.readLine()) != null) {
            if (f.trim().length() == 0) continue;
            files.add(f);
        }
        in.close();
        Iterator itr = files.iterator();
        String sysLine = (String)itr.next();
        File sysAssembly = DotNetWalaUtil.getSysAssemblyFile(sysLine);
        HashSet appAssemblies = HashSetFactory.make();
        HashSet libAssemblies = HashSetFactory.make();
        while (itr.hasNext()) {
            String line = (String)itr.next();
            line = ScopeUtil.replacePropertyRefs((String)line);
            line = ScopeUtil.adjustFilePathForPlatform((String)line);
            int indexOfFirstComma = line.indexOf(44);
            String appOrLib = line.substring(0, indexOfFirstComma);
            String path = line.substring(indexOfFirstComma + 1);
            if (appOrLib.equals("app")) {
                appAssemblies.add(new File(path));
                continue;
            }
            assert (appOrLib.equals("lib"));
            libAssemblies.add(new File(path));
        }
        LowLevelInterface i = AbstractLowLevelInterface.getDotNetLowLevelInterface();
        i.clearCaches();
        CLRAnalysisScope scope = new CLRAnalysisScope(sysAssembly, (Set)libAssemblies, (Set)appAssemblies, i);
        return scope;
    }

    private static File getSysAssemblyFile(String sysLine) {
        if (PlatformUtil.onMacOSX() || PlatformUtil.onIKVM()) {
            sysLine = "sys,${TaintResources)/rasde/repository/windowsDLLS/mscorlib.dll";
        }
        sysLine = ScopeUtil.replacePropertyRefs((String)sysLine);
        sysLine = ScopeUtil.adjustFilePathForPlatform((String)sysLine);
        String sysPath = sysLine.substring(sysLine.indexOf(44) + 1);
        File sysAssembly = new File(sysPath);
        return sysAssembly;
    }

    public static Iterable<IClass> getApplicationClasses(IClassHierarchy cha) {
        ArrayList<IClass> result = new ArrayList<IClass>();
        for (IClassLoader cl : cha.getLoaders()) {
            if (!cha.getScope().isApplicationLoader(cl)) continue;
            for (IClass klass : Iterator2Iterable.make((Iterator)cl.iterateAllClasses())) {
                result.add(klass);
            }
        }
        return result;
    }
}

