/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.apache.wink.json4j.JSON;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;

public class HttpResponse {
    private static final int READ_SIZE = 16384;
    private byte[] m_content = null;
    private HttpURLConnection m_connection;

    public HttpResponse(HttpURLConnection conn) {
        this.m_connection = conn;
    }

    public int getResponseCode() {
        try {
            return this.m_connection.getResponseCode();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.m_connection.getHeaderFields();
    }

    public String getHeaderField(String name) {
        Map<String, List<String>> responseHeaders = this.getResponseHeaders();
        List<String> values = responseHeaders.containsKey(name) ? responseHeaders.get(name) : null;
        return values == null ? null : values.get(0);
    }

    public String getResponseBodyAsString() {
        String body = null;
        try {
            if (this.hasResponseBody()) {
                body = new String(this.m_content, "UTF-8");
            }
        }
        catch (IOException e) {
            body = new String(this.m_content);
        }
        return body;
    }

    public JSONArtifact getResponseBodyAsJSON() throws IOException, JSONException {
        if (!this.hasResponseBody()) {
            return null;
        }
        return JSON.parse((String)this.getResponseBodyAsString());
    }

    public void getResponseBodyAsFile(File destination) throws IOException {
        FileOutputStream out = new FileOutputStream(destination, false);
        this.getHttpResponseBody(out);
        out.close();
    }

    public boolean isSuccess() {
        int rc = this.getResponseCode();
        return rc >= 200 && rc < 300;
    }

    private boolean hasResponseBody() throws IOException {
        if (this.m_content == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getHttpResponseBody(out);
            this.m_content = out.toByteArray();
        }
        return this.m_content != null;
    }

    private void getHttpResponseBody(OutputStream out) throws IOException {
        boolean error;
        int responseCode = this.getResponseCode();
        boolean bl = error = responseCode < 200 || responseCode >= 300;
        if (responseCode != 204) {
            InputStream is;
            InputStream inputStream = is = error ? this.m_connection.getErrorStream() : this.m_connection.getInputStream();
            if (is == null) {
                return;
            }
            byte[] buf = new byte[16384];
            int result = 0;
            while ((result = is.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, result);
            }
            out.flush();
            is.close();
        }
    }
}

