/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.sast;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.scanners.sast.SASTConstants;
import com.hcl.appscan.sdk.utils.ArchiveUtil;
import com.hcl.appscan.sdk.utils.ServiceUtil;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SAClient
implements SASTConstants {
    private static final File DEFAULT_INSTALL_DIR = new File(System.getProperty("user.home"), ".appscan");
    private static final String SACLIENT = "SAClientUtil";
    private static final String VERSION_INFO = "version.info";
    private IProgress m_progress;
    private ProcessBuilder m_builder;
    private File m_installDir;
    private Proxy m_proxy;

    public SAClient() {
        this(new DefaultProgress(), Proxy.NO_PROXY);
    }

    public SAClient(Proxy proxy) {
        this(new DefaultProgress(), proxy);
    }

    public SAClient(IProgress progress) {
        this(progress, Proxy.NO_PROXY);
    }

    public SAClient(IProgress progress, Proxy proxy) {
        this.m_progress = progress;
        String install = System.getProperty("SAClientInstall");
        this.m_installDir = install == null ? DEFAULT_INSTALL_DIR : new File(install);
        this.m_proxy = proxy;
    }

    public int run(String workingDir, Map<String, String> properties) throws IOException, ScannerException {
        return this.runClient(workingDir, this.getClientArgs(properties), properties.get("APPSCAN_IRGEN_CLIENT"), properties.get("APPSCAN_CLIENT_VERSION"), properties.get("IRGEN_CLIENT_PLUGIN_VERSION"));
    }

    @Deprecated
    public int run(String workingDir, List<String> args) throws IOException, ScannerException {
        return this.runClient(workingDir, args, "", "", "");
    }

    private int runClient(String workingDir, List<String> args, String irGenClient, String clientVersion, String irgenClientPluginVersion) throws IOException, ScannerException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getClientScript());
        arguments.addAll(args);
        this.m_builder = new ProcessBuilder(arguments);
        this.m_builder.directory(new File(workingDir));
        this.m_builder.redirectErrorStream(true);
        if (irGenClient != null && !irGenClient.isEmpty()) {
            this.m_builder.environment().put("APPSCAN_IRGEN_CLIENT", irGenClient);
        }
        if (clientVersion != null && !clientVersion.isEmpty()) {
            this.m_builder.environment().put("APPSCAN_CLIENT_VERSION", clientVersion);
        }
        if (irgenClientPluginVersion != null && !irgenClientPluginVersion.isEmpty()) {
            this.m_builder.environment().put("IRGEN_CLIENT_PLUGIN_VERSION", irgenClientPluginVersion);
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.preparing.irx", this.getLocalClientVersion())));
        final Process proc = this.m_builder.start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        SAClient.this.m_progress.setStatus(new Message(0, line));
                    }
                }
                catch (IOException e) {
                    SAClient.this.m_progress.setStatus(e);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        SAClient.this.m_progress.setStatus(e);
                    }
                }
            }
        }).start();
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            this.m_progress.setStatus(e);
            return -1;
        }
        return proc.exitValue();
    }

    public String getClientScript() throws IOException, ScannerException {
        File clientZip;
        String scriptPath = "bin" + File.separator + this.getScriptName();
        File install = this.findClientInstall();
        if (install != null && new File(install, scriptPath).isFile() && !this.shouldUpdateClient()) {
            return new File(install, scriptPath).getAbsolutePath();
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.downloading.client", new Object[0])));
        if (install != null && install.isDirectory()) {
            this.deleteDirectory(install);
        }
        if ((clientZip = new File(this.m_installDir, "SAClientUtil.zip")).isFile()) {
            clientZip.delete();
        }
        try {
            ServiceUtil.getSAClientUtil(clientZip, this.m_proxy);
        }
        catch (OutOfMemoryError e) {
            throw new ScannerException(Messages.getMessage("error.out.of.memory", new Object[0]));
        }
        catch (IOException e) {
            throw new ScannerException(Messages.getMessage("error.download.client", e.getLocalizedMessage()));
        }
        if (clientZip.isFile()) {
            this.m_progress.setStatus(new Message(0, Messages.getMessage("message.download.complete", new Object[0])));
            this.m_progress.setStatus(new Message(0, Messages.getMessage("message.extracting.client", new Object[0])));
            ArchiveUtil.unzip(clientZip, this.m_installDir);
            this.m_progress.setStatus(new Message(0, Messages.getMessage("message.done", new Object[0])));
        }
        return new File(this.findClientInstall(), scriptPath).getAbsolutePath();
    }

    private String getScriptName() {
        return SystemUtil.isWindows() ? "appscan.bat" : "appscan.sh";
    }

    public boolean majorVersionChanged() throws IOException {
        String serverMajorVersion = ServiceUtil.getSAClientVersion(this.m_proxy);
        String localMajorVersion = this.getLocalClientVersion();
        if (serverMajorVersion != null && localMajorVersion != null) {
            serverMajorVersion = serverMajorVersion.substring(0, 1);
            return !(localMajorVersion = localMajorVersion.substring(0, 1)).equals(serverMajorVersion);
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.server.unavailable", new Object[0])));
        return false;
    }

    public boolean shouldUpdateClient() throws IOException {
        String serverVersion = ServiceUtil.getSAClientVersion(this.m_proxy);
        String localVersion = this.getLocalClientVersion();
        if (this.compareVersions(localVersion, serverVersion) && System.getProperty("skipUpdate") == null) {
            this.m_progress.setStatus(new Message(0, Messages.getMessage("message.saclient.old", localVersion, serverVersion)));
            return true;
        }
        return false;
    }

    private File findClientInstall() {
        if (!this.m_installDir.isDirectory()) {
            return null;
        }
        File[] files = this.m_installDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(SAClient.SACLIENT) && new File(dir, name).isDirectory();
            }
        });
        if (files.length > 1) {
            File latest = files[0];
            String latestVersion = this.getVersionFromString(latest.getName());
            for (int i = 1; i < files.length; ++i) {
                String otherVersion = this.getVersionFromString(files[i].getName());
                if (this.compareVersions(latestVersion, otherVersion)) {
                    this.deleteDirectory(latest);
                    latest = files[i];
                    latestVersion = this.getVersionFromString(latest.getName());
                    continue;
                }
                this.deleteDirectory(files[i]);
            }
            return latest;
        }
        return files.length == 0 ? null : files[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocalClientVersion() {
        File versionInfo = new File(this.findClientInstall(), VERSION_INFO);
        String version = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(versionInfo));
            version = reader.readLine();
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.checking.local.version", e.getLocalizedMessage())));
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return version;
    }

    private void deleteDirectory(File directory) {
        if (!directory.isDirectory()) {
            directory.delete();
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.deleteDirectory(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }

    private List<String> getClientArgs(Map<String, String> properties) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("prepare");
        if (properties.containsKey("ScanName")) {
            args.add("-n");
            args.add(properties.get("ScanName"));
        }
        if (properties.containsKey("logDir")) {
            args.add("-l");
            args.add(properties.get("logDir"));
        }
        if (properties.containsKey("irxDir")) {
            args.add("-d");
            args.add(properties.get("irxDir"));
        }
        if (properties.containsKey("configFile")) {
            args.add("-c");
            args.add(properties.get("configFile"));
        }
        if (properties.containsKey("debug") || System.getProperty("debug".toUpperCase()) != null) {
            args.add("-X");
        }
        if (properties.containsKey("verbose")) {
            args.add("-v");
        }
        if (properties.containsKey("thirdParty") || System.getProperty("thirdParty") != null) {
            args.add("-t");
        }
        if (properties.containsKey("openSourceOnly") || System.getProperty("openSourceOnly") != null) {
            args.add("-oso");
        }
        return args;
    }

    private boolean compareVersions(String baseVersion, String newVersion) {
        if (baseVersion == null) {
            return true;
        }
        if (baseVersion != null && newVersion != null) {
            String[] base = baseVersion.split("\\.");
            String[] next = newVersion.split("\\.");
            try {
                for (int iter = 0; iter < base.length && iter < next.length; ++iter) {
                    int lVersion = Integer.parseInt(base[iter]);
                    int sVersion = Integer.parseInt(next[iter]);
                    if (!(iter == 0 && lVersion < sVersion || iter == 1 && lVersion < sVersion) && (iter != 2 || lVersion >= sVersion)) continue;
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private String getVersionFromString(String name) {
        String version = name.substring(SACLIENT.length());
        if (version.trim().startsWith(".")) {
            version = version.substring(1);
        }
        return version;
    }
}

