/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.Iterator;

public class EdgeFilteredNumberedGraph<T>
extends AbstractNumberedGraph<T> {
    private final NumberedGraph<T> delegate;
    private final IBinaryNaturalRelation ignoreEdges;
    private final Edges edges;

    public EdgeFilteredNumberedGraph(NumberedGraph<T> delegate, IBinaryNaturalRelation ignoreEdges) {
        this.delegate = delegate;
        this.ignoreEdges = ignoreEdges;
        this.edges = new Edges();
    }

    @Override
    protected NumberedEdgeManager<T> getEdgeManager() {
        return this.edges;
    }

    @Override
    protected NumberedNodeManager<T> getNodeManager() {
        return this.delegate;
    }

    private final class Edges
    implements NumberedEdgeManager<T> {
        private Edges() {
        }

        @Override
        public int getPredNodeCount(T N) {
            return this.getPredNodeNumbers(N).size();
        }

        @Override
        public Iterator<T> getPredNodes(T N) {
            return new NodeIterator(this.getPredNodeNumbers(N));
        }

        @Override
        public int getSuccNodeCount(T N) {
            return this.getSuccNodeNumbers(N).size();
        }

        @Override
        public Iterator<T> getSuccNodes(T N) {
            return new NodeIterator(this.getSuccNodeNumbers(N));
        }

        @Override
        public boolean hasEdge(T src, T dst) {
            return EdgeFilteredNumberedGraph.this.delegate.hasEdge(src, dst) && !EdgeFilteredNumberedGraph.this.ignoreEdges.contains(EdgeFilteredNumberedGraph.this.getNumber(src), EdgeFilteredNumberedGraph.this.getNumber(dst));
        }

        @Override
        public IntSet getPredNodeNumbers(T node) {
            return this.getFilteredNodeNumbers(node, EdgeFilteredNumberedGraph.this.delegate.getPredNodeNumbers(node));
        }

        private IntSet getFilteredNodeNumbers(T node, IntSet s) {
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            IntIterator it = s.intIterator();
            while (it.hasNext()) {
                int y = it.next();
                if (EdgeFilteredNumberedGraph.this.ignoreEdges.contains(y, EdgeFilteredNumberedGraph.this.getNumber(node))) continue;
                result.add(y);
            }
            return result;
        }

        @Override
        public IntSet getSuccNodeNumbers(T node) {
            return this.getFilteredNodeNumbers(node, EdgeFilteredNumberedGraph.this.delegate.getSuccNodeNumbers(node));
        }

        @Override
        public void addEdge(T src, T dst) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeAllIncidentEdges(T node) throws UnsupportedOperationException {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeEdge(T src, T dst) throws UnsupportedOperationException {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeIncomingEdges(T node) throws UnsupportedOperationException {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeOutgoingEdges(T node) throws UnsupportedOperationException {
            Assertions.UNREACHABLE();
        }

        private final class NodeIterator
        implements Iterator<T> {
            private final IntIterator nodeNumbers;

            private NodeIterator(IntSet nodeNumbers) {
                this.nodeNumbers = nodeNumbers.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.nodeNumbers.hasNext();
            }

            @Override
            public T next() {
                return EdgeFilteredNumberedGraph.this.getNode(this.nodeNumbers.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

