/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.file.extension;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.file.extension.ExtensionGroup;
import com.ibm.appscan.file.extension.FileExtensionException;
import com.ibm.appscan.file.extension.data.ExtensionReader;
import com.ibm.appscan.file.extension.data.ExtensionWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;

public class ExtensionManager {
    private HashMap<String, ExtensionGroup> m_groups;
    private File m_file;

    public ExtensionManager() {
        this.m_file = new File(CommonCore.getDirectoryLocator().getConfig(), "file_extensions.xml");
    }

    public ExtensionManager(File f) {
        this.m_file = f;
    }

    public HashMap<String, ExtensionGroup> getGroups() throws FileExtensionException {
        if (this.m_groups == null) {
            try {
                ExtensionReader r = new ExtensionReader(this.m_file);
                this.m_groups = r.getExtensionGroups();
            }
            catch (FileNotFoundException e) {
                throw new FileExtensionException(e);
            }
        }
        return this.m_groups;
    }

    public void save() throws FileExtensionException {
        this.save(this.m_file);
    }

    public void save(File f) throws FileExtensionException {
        ExtensionWriter w = new ExtensionWriter(f);
        w.save(this);
    }
}

