/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.file.extension.data;

import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.xml.XMLStreamReader;
import com.ibm.appscan.file.extension.Extension;
import com.ibm.appscan.file.extension.ExtensionGroup;
import com.ibm.appscan.file.extension.FileExtensionException;
import com.ibm.appscan.file.extension.FileExtensionXml;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class ExtensionReader
extends XMLStreamReader {
    private HashMap<String, ExtensionGroup> m_groups;
    private ExtensionGroup m_current_group;

    public ExtensionReader(File f) throws FileExtensionException, FileNotFoundException {
        this(new BufferedInputStream(new FileInputStream(f)));
    }

    public ExtensionReader(InputStream inputStream) throws FileExtensionException {
        this.init(inputStream);
    }

    public HashMap<String, ExtensionGroup> getExtensionGroups() throws FileExtensionException {
        return this.m_groups;
    }

    protected boolean process(StartElement element) {
        if (element.getName().getLocalPart().equals(FileExtensionXml.EXTENSION_GROUP)) {
            this.m_current_group = new ExtensionGroup(this.getAttribute(element, FileExtensionXml.NAME), this.getAttribute(element, FileExtensionXml.DISPLAY_NAME));
            this.m_groups.put(this.m_current_group.getName(), this.m_current_group);
        } else if (element.getName().getLocalPart().equals(FileExtensionXml.EXTENSION)) {
            this.m_current_group.addExtension(new Extension(this.getAttribute(element, FileExtensionXml.EXTENSION_ATT), Boolean.parseBoolean(this.getAttribute(element, FileExtensionXml.PBSA)), Boolean.parseBoolean(this.getAttribute(element, FileExtensionXml.ASSESS))));
        }
        return super.process(element);
    }

    protected void init(InputStream in) throws FileExtensionException {
        this.m_groups = new HashMap();
        try {
            this.read(in);
        }
        catch (XMLStreamException e) {
            throw new FileExtensionException(e);
        }
        finally {
            IOUtil.close((Closeable)in);
        }
    }
}

