/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.cache;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.cache.BaseVdbCache;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;

public abstract class DoubleCheckCache
extends BaseVdbCache {
    protected DoubleCheckCache(Language.LANGUAGE lang, VDBEnums.BUCKET b) {
        super(lang, b);
    }

    @Override
    public int addVdb(Vdb v) throws VDBGeneralException {
        this.processPreAddVdb(v);
        return super.addVdb(v);
    }

    protected abstract BaseVdbCache getFirstVdbCache();

    protected abstract BaseVdbCache getSecondVdbCache();

    private void processPreAddVdb(Vdb v) throws VDBGeneralException {
        if (this.getFirstVdbCache() == null || this.getSecondVdbCache() == null) {
            return;
        }
        for (VdbPackage p : v.getPackageMap().values()) {
            Vdb f_vdb = this.getFirstVdbCache().getVdb(p.getPackageName());
            Vdb s_vdb = this.getSecondVdbCache().getVdb(p.getPackageName());
            for (VdbClass c : p.getClassMap().values()) {
                for (Method m : c.getMethods()) {
                    if (f_vdb != null) {
                        f_vdb.deleteMethod(m);
                    }
                    if (s_vdb == null) continue;
                    s_vdb.deleteMethod(m);
                }
            }
            if (f_vdb != null) {
                if (f_vdb.getPackage(p.getPackageName()).getMethods().size() == 0) {
                    this.getFirstVdbCache().deletePackageFile(p);
                } else {
                    this.getFirstVdbCache().saveVdb(f_vdb);
                }
            }
            if (s_vdb == null) continue;
            if (s_vdb.getPackage(p.getPackageName()).getMethods().size() == 0) {
                this.getSecondVdbCache().deletePackageFile(p);
                continue;
            }
            this.getSecondVdbCache().saveVdb(s_vdb);
        }
        if (v.getNonClassFunctions().size() > 0) {
            Vdb f_vdb = this.getFirstVdbCache().getNonClassFuncsVdb();
            Vdb s_vdb = this.getSecondVdbCache().getNonClassFuncsVdb();
            for (Method m : v.getNonClassFunctions().values()) {
                if (f_vdb != null) {
                    f_vdb.deleteMethod(m);
                }
                if (s_vdb == null) continue;
                s_vdb.deleteMethod(m);
            }
            if (f_vdb != null) {
                if (f_vdb.getNonClassFunctions().size() == 0) {
                    this.getFirstVdbCache().deleteNonClassFuncFile();
                } else {
                    this.getFirstVdbCache().saveVdb(f_vdb);
                }
            }
            if (s_vdb != null) {
                if (s_vdb.getNonClassFunctions().size() == 0) {
                    this.getSecondVdbCache().deleteNonClassFuncFile();
                } else {
                    this.getFirstVdbCache().saveVdb(s_vdb);
                }
            }
        }
    }
}

