/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.ValidationRoutine;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.Rule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public abstract class DataProvider {
    private Language.LANGUAGE m_language;
    private HashMap<String, ValidationRoutine> m_val_routines;

    public DataProvider(Language.LANGUAGE lang) {
        this.m_language = lang;
    }

    public Language.LANGUAGE getLanguage() {
        return this.m_language;
    }

    public Vdb loadVdb(VDBEnums.BUCKET bucket, VdbPackage p) throws VDBGeneralException {
        return this.getVdb(bucket, p.getPackageName());
    }

    public abstract Vdb getVdb(VDBEnums.BUCKET var1, String var2) throws VDBGeneralException;

    public abstract void saveVdb(VDBEnums.BUCKET var1, Vdb var2) throws VDBGeneralException;

    public abstract void saveVdb(VDBEnums.BUCKET var1, Vdb var2, String var3) throws VDBGeneralException;

    public abstract void saveProperties() throws VDBGeneralException;

    public abstract Vdb getNonClassFuncsVdb(VDBEnums.BUCKET var1) throws VDBGeneralException;

    public abstract boolean deletePackage(VDBEnums.BUCKET var1, String var2);

    public abstract void deleteNonClassFuncs(VDBEnums.BUCKET var1) throws VDBGeneralException;

    public abstract Vdb getAuditVdb(Date var1, VDBEnums.BUCKET var2, String var3) throws VDBGeneralException;

    public abstract void saveAuditVdb(Date var1, VDBEnums.BUCKET var2, Vdb var3) throws VDBGeneralException;

    public abstract Vdb getAuditNonClassFuncsVdb(Date var1, VDBEnums.BUCKET var2) throws VDBGeneralException;

    public abstract boolean deleteAuditPackage(Date var1, VDBEnums.BUCKET var2, VdbPackage var3);

    public abstract Set<String> getPackages(VDBEnums.BUCKET var1) throws VDBException;

    public abstract Set<String> getAuditPackages(Date var1, VDBEnums.BUCKET var2) throws VDBException;

    public abstract ArrayList<String> getClassesForPackage(VDBEnums.BUCKET var1, String var2) throws VDBGeneralException;

    public abstract ArrayList<String> getAuditClassesForPackage(Date var1, VDBEnums.BUCKET var2, String var3) throws VDBGeneralException;

    public abstract Set<String> getMethods(VDBEnums.BUCKET var1) throws VDBException;

    public abstract Set<String> getClasses(VDBEnums.BUCKET var1) throws VDBException;

    public abstract ArrayList<String> getMethodsForClass(VDBEnums.BUCKET var1, String var2, String var3) throws VDBException;

    public abstract ArrayList<String> getAuditMethodsForClass(Date var1, VDBEnums.BUCKET var2, String var3, String var4) throws VDBException;

    public abstract Set<String> getNonClassFunctions(VDBEnums.BUCKET var1) throws VDBException;

    public abstract Set<String> getAuditNonClassFunctions(Date var1, VDBEnums.BUCKET var2) throws VDBException;

    public abstract void deleteAuditNonClassFuncFile(Date var1, VDBEnums.BUCKET var2) throws VDBGeneralException;

    public abstract Collection<Rule> getRules() throws VDBGeneralException;

    public abstract void saveRules(Collection<Rule> var1) throws VDBGeneralException;

    public void clearBucket(VDBEnums.BUCKET b) throws VDBGeneralException {
        if (b != VDBEnums.BUCKET.FACTORY) {
            this.clearBucket_(b);
        }
    }

    protected abstract void clearBucket_(VDBEnums.BUCKET var1) throws VDBGeneralException;

    public String getPackageFileDir(VdbPackage p) {
        return this.getPackageFileDir(p.getPackageName());
    }

    public String getClassDir(VdbClass c) {
        return this.getPackageFileDir(c.getClassName());
    }

    public String getPackageFileDir(String package_name) {
        if (package_name.equals("nonClassFuncs")) {
            return ".";
        }
        StringBuilder s = new StringBuilder();
        s.append(package_name.replace('.', File.separatorChar));
        s.append(File.separatorChar);
        return s.toString();
    }

    public String getPackageFileName(VdbPackage p) {
        return this.getPackageFileName(p.getPackageName());
    }

    public String getPackageFileName(String package_name) {
        if (package_name.equals("nonClassFuncs")) {
            return "nonClassFuncs.vdb";
        }
        return package_name + ".vdb";
    }

    public String getNonClassFuncString() {
        return "nonClassFuncs.vdb";
    }

    public abstract HashMap<String, Vdb> getVdbs(VDBEnums.BUCKET var1) throws VDBGeneralException;

    public synchronized HashMap<String, ValidationRoutine> getValidationRoutines() {
        if (this.m_val_routines == null) {
            this.m_val_routines = this.loadValidationRoutines();
        }
        return this.m_val_routines;
    }

    protected abstract HashMap<String, ValidationRoutine> loadValidationRoutines();
}

