/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file.save;

import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.vdb.annotation.VdbAnnotation;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Property;
import com.ibm.appscan.vdb.method.markup.Taint;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.method.markup.ao.Option;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.data.file.save.RuleWriter;
import com.ibm.appscan.vdb.rule.Rule;
import java.util.Iterator;

public class MethodWriter {
    private DOMWriter m_writer;

    protected MethodWriter(DOMWriter writer) {
        this.m_writer = writer;
    }

    public void writeMethod(Method m) throws VDBGeneralException {
        StringBuffer str;
        if (m.isNcf()) {
            this.m_writer.beginElement("nonclassfunction");
        } else {
            this.m_writer.beginElement("method");
        }
        if (m.getId() != null && !m.getId().equals("0")) {
            this.m_writer.setAttribute("vuln_id", m.getId());
        }
        this.m_writer.beginElement("simple_name");
        this.m_writer.endElement(m.getSignature().substring(0, m.getSignature().indexOf("(")));
        this.m_writer.beginElement("signature");
        this.m_writer.endElement(m.getSignature());
        if (m.getInfoId() != null) {
            this.m_writer.beginElement("info_rule");
            this.m_writer.setAttribute("id", m.getInfoId());
            this.m_writer.endElement();
        }
        for (ActionObject actionObject : m.getAllActionObjects()) {
            if (actionObject.isSink()) {
                this.writeSink(actionObject);
                continue;
            }
            if (actionObject.isSource()) {
                this.writeSource(actionObject);
                continue;
            }
            this.writeActionObject(actionObject);
        }
        if (m.getWritesThrough() != null) {
            this.m_writer.beginElement("writes_through");
            this.m_writer.setAttribute("param", m.getWritesThrough().toString());
            this.m_writer.endElement();
        }
        if (m.getAlias() != null) {
            this.m_writer.beginElement("stores_writeable_aliases");
            this.m_writer.setAttribute("param", m.getAlias().getParameter().toString());
            this.m_writer.setAttribute("return", Boolean.toString(m.getAlias().isReturn()));
            this.m_writer.endElement();
        }
        for (Taint taint : m.getTaints()) {
            if (taint.isNotSusceptibleToTaint()) {
                this.m_writer.beginElement("does_not_propagate_taint");
            } else {
                this.m_writer.beginElement("propagates_taint");
                this.m_writer.setAttribute("dst_param", taint.getDstParam().toString());
                this.m_writer.setAttribute("source_param", taint.getSourceParam().toString());
                this.m_writer.setAttribute("return", taint.isReturn() || taint.getDstParam().isRtn() ? "true" : "false");
            }
            this.m_writer.endElement();
        }
        for (Property property : m.getAllProperties()) {
            this.writeProperty(property);
        }
        if (m.isCallBack()) {
            this.m_writer.beginElement("call_back");
            this.m_writer.endElement();
        }
        if (m.getRules().size() > 0) {
            this.m_writer.beginElement("method_rules");
            Iterator<Object> rw = new RuleWriter(this.m_writer);
            for (Rule rule : m.getRules()) {
                try {
                    ((RuleWriter)((Object)rw)).writeRule(rule);
                }
                catch (BadRuleException e) {
                    e.logException();
                }
            }
            this.m_writer.endElement();
        }
        if (m.getComments().size() > 0) {
            for (String string : m.getComments()) {
                this.m_writer.beginElement("comment");
                this.m_writer.endElement(string);
            }
        }
        if (!m.getMethodAnnotations().isEmpty()) {
            this.m_writer.beginElement("method_annotations");
            for (VdbAnnotation vdbAnnotation : m.getMethodAnnotations()) {
                this.writeAnnotation(vdbAnnotation);
            }
            this.m_writer.endElement();
        }
        if (!m.getClassAnnotations().isEmpty()) {
            this.m_writer.beginElement("class_annotations");
            for (VdbAnnotation vdbAnnotation : m.getClassAnnotations()) {
                this.writeAnnotation(vdbAnnotation);
            }
            this.m_writer.endElement();
        }
        if (!m.getArgAnnotations().isEmpty()) {
            this.m_writer.beginElement("arg_annotations");
            for (String string : m.getArgAnnotations().keySet()) {
                this.m_writer.beginElement("arg");
                this.m_writer.setAttribute("type", string);
                for (VdbAnnotation a : m.getArgAnnotations().get(string)) {
                    this.writeAnnotation(a);
                }
                this.m_writer.endElement();
            }
            this.m_writer.endElement();
        }
        if (m.getClassHierachyChain() != null && m.getClassHierachyChain().size() > 0) {
            this.m_writer.beginElement("class_hierachy_chain");
            str = new StringBuffer();
            for (String string : m.getClassHierachyChain()) {
                str.append(string);
                str.append(",");
            }
            str.deleteCharAt(str.length() - 1);
            this.m_writer.endElement(str.toString());
        }
        if (m.getClassInterfaces() != null && m.getClassInterfaces().size() > 0) {
            this.m_writer.beginElement("class_interfaces");
            str = new StringBuffer();
            for (String string : m.getClassInterfaces()) {
                str.append(string);
                str.append(",");
            }
            str.deleteCharAt(str.length() - 1);
            this.m_writer.endElement(str.toString());
        }
        this.m_writer.endElement();
    }

    private void writeAnnotation(VdbAnnotation a) {
        this.m_writer.beginElement("annotation");
        this.m_writer.setAttribute("name", a.getName());
        for (String s : a.getArgs().keySet()) {
            this.m_writer.beginElement("AnnotationMember");
            this.m_writer.setAttribute("key", s);
            this.m_writer.setAttribute("value", a.getArgs().get(s));
            this.m_writer.endElement();
        }
        this.m_writer.endElement();
    }

    private void writeActionObject(ActionObject ao) throws VDBGeneralException {
        this.m_writer.beginElement("rule");
        this.m_writer.beginElement("ActionObject");
        if (ao.getId() != null) {
            this.m_writer.setAttribute("id", ao.getId());
        }
        this.m_writer.beginElement("signature");
        this.m_writer.endElement(ao.getAoType().toString());
        for (Option o : ao.getOptions()) {
            this.writeOptions(o);
        }
        this.m_writer.endElement();
        this.m_writer.beginElement("severity");
        this.m_writer.endElement(ao.getSeverity().toString());
        this.m_writer.beginElement("vulnerability_type");
        this.m_writer.endElement(VdbProvider.getPropertyProvider().getPropertyFqn(ao.getVulnerabilityId()));
        if (ao.getParameter() != null) {
            this.m_writer.beginElement("trace_information");
            this.m_writer.beginElement("sink");
            this.m_writer.beginElement("taint_susceptible_input");
            this.m_writer.setAttribute("param", ao.getParameter().toString());
            this.m_writer.endElement();
            this.m_writer.endElement();
            this.m_writer.endElement();
        }
        this.m_writer.endElement();
    }

    private void writeOptions(Option o) {
        this.m_writer.beginElement("option");
        this.m_writer.setAttribute("option_name", o.getOptionName().toString());
        this.m_writer.setAttribute("parameter_position", o.getParameter().toString());
        if (o.getOptionValue() != null) {
            this.m_writer.setAttribute("value", o.getOptionValue());
        }
        this.m_writer.setAttribute("operator", o.getOptionOperator().toString());
        if (o.getMaxCon() != VDBEnums.OPTION_CONFIDENCE.NULL) {
            this.m_writer.setAttribute("max_confidence", o.getMaxCon().toString());
        }
        if (o.getMinCon() != VDBEnums.OPTION_CONFIDENCE.NULL) {
            this.m_writer.setAttribute("min_confidence", o.getMinCon().toString());
        }
        this.m_writer.endElement();
    }

    private void writeSink(ActionObject ao) throws VDBGeneralException {
        if (ao.getAoType() == VDBEnums.AO_TYPE.OutputAnyNotValidated) {
            this.m_writer.beginElement("sink_rule");
            if (ao.getId() != null) {
                this.m_writer.setAttribute("id", ao.getId());
            }
            this.m_writer.beginElement("severity");
            this.m_writer.endElement(ao.getSeverity().toString());
            this.m_writer.beginElement("vulnerability_type");
            this.m_writer.endElement(VdbProvider.getPropertyProvider().getPropertyFqn(ao.getVulnerabilityId()));
            this.m_writer.beginElement("taint_susceptible_input");
            this.m_writer.setAttribute("param", ao.getParameter().toString());
            this.m_writer.endElement();
            this.m_writer.endElement();
        } else {
            this.writeActionObject(ao);
        }
    }

    private void writeSource(ActionObject ao) {
        this.m_writer.beginElement("source_rule");
        if (ao.getId() != null) {
            this.m_writer.setAttribute("id", ao.getId());
        }
        this.m_writer.beginElement("tainted_output");
        this.m_writer.setAttribute("param", ao.getParameter().toString());
        this.m_writer.setAttribute("return", ao.isReturn() || ao.getParameter().isRtn() ? "true" : "false");
        this.m_writer.endElement();
        this.m_writer.endElement();
    }

    private void writeProperty(Property p) throws VDBGeneralException {
        this.m_writer.beginElement("property");
        this.m_writer.endElement(p.getProperty());
    }
}

