/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.method.audit;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBConstants;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import com.ibm.appscan.vdb.provider.method.audit.BaseAuditProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class AuditProvider {
    private HashMap<String, MethodProvider> m_before_providers;
    private HashMap<String, MethodProvider> m_after_providers;
    private Language.LANGUAGE m_lang;

    public AuditProvider(Language.LANGUAGE lang) {
        this.m_lang = lang;
    }

    public void addBeforeMethod(Method m) throws VDBGeneralException, BadMarkupException {
        Date d = new Date();
        Vdb v = this.getBeforeProvider(d).getVdb(m.getPackageName());
        if (v == null) {
            v = new Vdb(m.getLang());
        }
        v.addMethod(m);
        this.getBeforeProvider(d).saveVdb(v);
    }

    public void addAfterMethod(Method m) throws VDBGeneralException, BadMarkupException {
        Date d = new Date();
        Vdb v = this.getAfterProvider(d).getVdb(m.getPackageName());
        if (v == null) {
            v = new Vdb(m.getLang());
        }
        v.addMethod(m);
        this.getAfterProvider(d).saveVdb(v);
    }

    public ArrayList<Date> getDateAuditDates() throws VDBGeneralException {
        return this.getDateAuditDates(null, null);
    }

    public ArrayList<String> getStringAuditDates() throws VDBGeneralException {
        return this.getStringAuditDates(null, null);
    }

    public ArrayList<Date> getDateAuditDates(Date fromDate, Date toDate) throws VDBGeneralException {
        return VdbProvider.getAuditListProvider(this.m_lang).getDateAvailableAuditDates(fromDate, toDate);
    }

    public ArrayList<String> getStringAuditDates(Date fromDate, Date toDate) throws VDBGeneralException {
        return VdbProvider.getAuditListProvider(this.m_lang).getStringAvailableAuditDates(fromDate, toDate);
    }

    public MethodProvider getBeforeProvider(Date d) {
        return this.getBeforeProvider(this.getFDateString(d));
    }

    public MethodProvider getBeforeProvider(String date_string) {
        if (!this.getBeforeProviderMap().containsKey(date_string)) {
            this.getBeforeProviderMap().put(date_string, new BaseAuditProvider(this.m_lang, VDBEnums.BUCKET.BEFORE, date_string));
        }
        return this.getBeforeProviderMap().get(date_string);
    }

    public MethodProvider getAfterProvider(Date d) {
        return this.getAfterProvider(this.getFDateString(d));
    }

    public MethodProvider getAfterProvider(String date_string) {
        if (!this.getAfterProviderMap().containsKey(date_string)) {
            this.getAfterProviderMap().put(date_string, new BaseAuditProvider(this.m_lang, VDBEnums.BUCKET.AFTER, date_string));
        }
        return this.getAfterProviderMap().get(date_string);
    }

    private String getFDateString(Date d) {
        return VDBConstants.AUDIT_DATE_FORMAT.format(d);
    }

    private HashMap<String, MethodProvider> getBeforeProviderMap() {
        if (this.m_before_providers == null) {
            this.m_before_providers = new HashMap();
        }
        return this.m_before_providers;
    }

    private HashMap<String, MethodProvider> getAfterProviderMap() {
        if (this.m_after_providers == null) {
            this.m_after_providers = new HashMap();
        }
        return this.m_after_providers;
    }
}

