/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.rest;

import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.provider.data.file.load.VdbReader;
import com.ibm.appscan.vdb.provider.data.file.save.VdbWriter;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public abstract class BaseRestClient {
    private String m_host = "localhost";
    private String m_port = "9080";
    private boolean m_secure = false;

    protected BaseRestClient(String host, String port, boolean secure) {
        this.m_host = host;
        this.m_port = port;
        this.m_secure = secure;
    }

    protected abstract String getApplicationBase();

    protected HttpURLConnection getConnection(String rest, String method) throws VDBGeneralException {
        try {
            URL url = new URL(this.m_secure ? "https//" : "http://" + this.m_host + ":" + this.m_port + "/AppScanMarkupServer/" + this.getApplicationBase() + "/" + rest);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method);
            conn.setReadTimeout(100000);
            conn.setConnectTimeout(150000);
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "multipart/form-data");
            conn.setRequestProperty("Connection", "Keep-Alive");
            return conn;
        }
        catch (ProtocolException e) {
            throw new VDBGeneralException(e);
        }
        catch (MalformedURLException e) {
            throw new VDBGeneralException(e);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    protected Set<String> splitResponse(HttpURLConnection conn, String separator) throws IOException {
        StringBuffer response = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        ArrayList<String> items = new ArrayList<String>();
        if (response.length() > 0) {
            for (String p : response.toString().split(separator)) {
                items.add(p);
            }
        }
        Collections.sort(items);
        conn.disconnect();
        return (Set)((Object)items);
    }

    protected String getResponse(HttpURLConnection conn) throws IOException {
        StringBuffer response = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        conn.disconnect();
        return response.toString();
    }

    protected Vdb getVdb(InputStream stream) throws VDBGeneralException {
        VdbReader handler = new VdbReader(stream);
        handler.parse();
        return handler.getVdb();
    }

    @SuppressSecurityTrace
    protected void addVdbPart(OutputStream output, Vdb v) throws VDBGeneralException {
        try {
            output.write("Content-Disposition: form-data; name=\"vdb\"".getBytes());
            output.write(System.getProperty("line.separator").getBytes());
            output.write("Content-Type: multipart/form-data".getBytes());
            output.write(System.getProperty("line.separator").getBytes());
            output.write("Content-Transfer-Encoding: binary".getBytes());
            output.write(System.getProperty("line.separator").getBytes());
            VdbWriter writer = new VdbWriter(output);
            writer.writeVdb(v);
            output.flush();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }
}

