/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule.method;

import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.rule.SearchRule;

public class ArgCountRule
extends SearchRule {
    @Override
    protected void validateOperator(VDBEnums.RULE_OPERATOR operator) throws BadRuleException {
        if (operator != VDBEnums.RULE_OPERATOR.INTEGER_EQUALS && operator != VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN && operator != VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN_EQUALS && operator != VDBEnums.RULE_OPERATOR.INTEGER_LESS_THAN && operator != VDBEnums.RULE_OPERATOR.INTEGER_LESS_THAN_EQUALS && operator != VDBEnums.RULE_OPERATOR.INTEGER_NOT_EQUALS) {
            throw new BadRuleException("Cannot use a string operator with an integer rule:{0}", operator.toString());
        }
    }

    public void setArgCountValue(int value) throws BadRuleException {
        this.setRuleValue(Integer.toString(value));
    }

    public int getArgCount() {
        if (!VdbProvider.isNumeric(this.getRuleValue())) {
            return 10000000;
        }
        return Integer.parseInt(this.getRuleValue());
    }

    @Override
    public boolean searchRule(Method m) {
        return this.compareValues(this.getArgCount(), m.getArgs().size());
    }

    @Override
    public String getDetailName() {
        return "Argument Count";
    }

    @Override
    public boolean allowsContains() {
        return false;
    }
}

