/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.aspdotnetmvc3;

import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.Utils;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.EnclosingFormal;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;

public class AspDotNetValidator {
    private HighLevelSyntheticMethod modelValidatorSynMethod = null;
    private TypeReference modelTypeRef;
    private F4FApp app;

    public AspDotNetValidator(TypeReference modelTypeRef, F4FApp app) {
        this.modelTypeRef = modelTypeRef;
        this.app = app;
    }

    public HighLevelSyntheticMethod getModelValidateSynMethod() {
        if (this.modelValidatorSynMethod == null) {
            this.modelValidatorSynMethod = this.createValidatorSyntheticMethod();
            if (this.modelValidatorSynMethod == null) {
                return null;
            }
            this.modelValidatorSynMethod.setReturnedValue((Param)EnclosingFormal.FIRST);
        }
        return this.modelValidatorSynMethod;
    }

    private String getVdbSignatureForModelValidator() {
        try {
            String modelVDBSigActual = DotNetVDBUtil.convertWalaDotNetGenericSig2VDB((TypeReference)this.modelTypeRef, (IClassHierarchy)this.app.getClassHierarchy());
            String modelVDBSig = Utils.removeGenericsFromTypeName((String)modelVDBSigActual);
            String vdbSig = "AppScan.Synthetic.Validator.dotNetMVC." + modelVDBSig.replace(".", "_") + "(" + modelVDBSig + "):" + modelVDBSig;
            System.out.println("vdbSig = " + vdbSig);
            return vdbSig;
        }
        catch (DotNetVDBUtil.UnresolvedGenericTypeException e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)((Object)e))}));
            return null;
        }
    }

    private HighLevelSyntheticMethod createValidatorSyntheticMethod() {
        String vdbSig = this.getVdbSignatureForModelValidator();
        if (vdbSig == null) {
            return null;
        }
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{vdbSig}));
        HighLevelSyntheticMethod validatorSynMethod = HighLevelSyntheticMethod.make((String)vdbSig);
        validatorSynMethod.setReturnedValue((Param)EnclosingFormal.FIRST);
        return validatorSynMethod;
    }
}

