/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup;

import com.hcl.appscan.common.error.ComponentException;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.LogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.ica.markup.MarkupRunner;
import com.ibm.appscan.ica.markup.Messages;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class MarkupMetricsManager
implements Runnable {
    private static Vdb m_ica20_stats_vdb;
    private static File m_scan;
    private static ILogManager m_logger;

    public MarkupMetricsManager(File scan, Vdb v) {
        m_scan = scan;
        m_logger = new MarkupMetricLogManager(new File(scan, "logs"));
        try {
            m_ica20_stats_vdb = new Vdb(v);
        }
        catch (VDBException e) {
            m_logger.log(new Message(1, Messages.getMessage("ica.2.stats.vdb.error", e.getMessage())));
        }
    }

    @Override
    public void run() {
        if (m_ica20_stats_vdb == null) {
            m_logger.log(new Message(1, Messages.getMessage("ica.2.stats.vdb.error", "VDB is null.")));
            return;
        }
        try {
            this.writeIcaMetricsSummary(this.createIcaMetrics(this.generateIca2Vdb()));
        }
        catch (ComponentException | IfaException | VDBException e) {
            m_logger.log(new Message(1, Messages.getMessage("ica.2.stats.vdb.error", e.getMessage())));
        }
        catch (JSONException e) {
            m_logger.log(new Message(1, Messages.getMessage("ica.2.stats.json.error", e.getMessage())));
        }
        catch (IOException e) {
            m_logger.log(new Message(1, Messages.getMessage("ica.2.stats.vdb.error", e.getMessage())));
        }
        finally {
            m_logger.close();
        }
    }

    private synchronized long generateIca2Vdb() throws ComponentException, IfaException, VDBException {
        long start_time = System.currentTimeMillis();
        m_ica20_stats_vdb = new MarkupRunner(m_logger).applyMarkupIcaStats(m_ica20_stats_vdb);
        m_logger.log(new Message(1, Messages.getMessage("ica.2.stats.vdb.stop", new Object[0])));
        return start_time;
    }

    private synchronized JSONObject createIcaMetrics(long start_time) throws JSONException {
        JSONArray ica_jsonarray = new JSONArray();
        JSONObject ica_summary = new JSONObject();
        JSONObject ica_obj_main = new JSONObject();
        int markup_count = 0;
        m_logger.log(new Message(1, Messages.getMessage("ica.2.stats.file.start", new Object[0])));
        for (Method m : m_ica20_stats_vdb.getMethods()) {
            if (!m.getSources().isEmpty()) {
                JSONObject obj = new JSONObject();
                ++markup_count;
                obj.put("type", (Object)"stats");
                obj.put("Language", (Object)m_ica20_stats_vdb.getLang().toString());
                obj.put("SourceSig", (Object)m.getSignature());
                obj.put("SinkSig", (Object)"");
                obj.put("VulnerabilityType", (Object)"");
                ica_jsonarray.put((Map)obj);
            }
            for (ActionObject ao : m.getSinks()) {
                JSONObject obj = new JSONObject();
                ++markup_count;
                obj.put("type", (Object)"stats");
                obj.put("Language", (Object)m_ica20_stats_vdb.getLang().toString());
                obj.put("SourceSig", (Object)"");
                obj.put("SinkSig", (Object)m.getSignature());
                obj.put("VulnerabilityType", (Object)ao.getVulnerability());
                ica_jsonarray.put((Map)obj);
            }
        }
        ica_obj_main.put("ICA2_Stats", (Collection)ica_jsonarray);
        ica_summary.put("type", (Object)"summary");
        ica_summary.put("MethodsToIca", m_ica20_stats_vdb.getMethods().size());
        ica_summary.put("MarkupFound", markup_count);
        ica_summary.put("TimeTakenSeconds", (double)System.currentTimeMillis() - (double)start_time / 1000.0);
        ica_obj_main.put("ICA_Summary", (Map)ica_summary);
        m_logger.log(new Message(1, Messages.getMessage("ica.2.stats.file.stop", new Object[0])));
        m_logger.log(new Message(1, "ICA 2.0 Stats collection completed in " + ((double)System.currentTimeMillis() - (double)start_time / 1000.0) + " seconds with " + m_ica20_stats_vdb.getMethods().size() + " methods."));
        return ica_obj_main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeIcaMetricsSummary(JSONObject ica_obj_main) throws JSONException, IOException {
        BufferedOutputStream out = null;
        String newLine = System.lineSeparator();
        try {
            out = new BufferedOutputStream(new FileOutputStream(new File(m_scan.getParent() + File.separator + "results" + File.separator + System.getProperty("APPSCAN_AGENT_JOBID") + ".ica.stats.json"), true));
            ((OutputStream)out).write(ica_obj_main.getJSONObject("ICA_Summary").toString().getBytes());
            ((OutputStream)out).write(newLine.getBytes());
            JSONArray array = ica_obj_main.getJSONArray("ICA2_Stats");
            for (int a = 0; a < array.length(); ++a) {
                ((OutputStream)out).write(array.getJSONObject(a).toString().getBytes());
                ((OutputStream)out).write(newLine.getBytes());
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Closeable)out);
        m_logger.log(new Message(1, Messages.getMessage("ica.2.stats.file.json", m_scan.getParent() + File.separator + "results" + File.separator + System.getProperty("APPSCAN_AGENT_JOBID") + ".ica.stats.json")));
    }

    private class MarkupMetricLogManager
    extends LogManager {
        private File m_log;

        MarkupMetricLogManager(File logDir) {
            this.m_log = new File(logDir, "ica_stats.log");
            this.init();
        }

        public File getLogFile() {
            return this.m_log;
        }

        protected void fallbackLog(Message message) {
            CommonCore.getLogManager().log(message);
        }
    }
}

